/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.about;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jaxx.runtime.SwingUtil;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.widgets.about.AboutUI;
import org.nuiton.util.Resource;

public class AboutUIBuilder {
    public static final String CLOSE_ACTION = "close";
    protected final AboutUI ui;

    public AboutUIBuilder(Frame parent) {
        Preconditions.checkNotNull((Object)parent);
        this.ui = new AboutUI(parent, true);
        AbstractAction closeAction = new AbstractAction(CLOSE_ACTION){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutUIBuilder.this.ui.dispose();
            }
        };
        closeAction.putValue("Name", null);
        closeAction.putValue("SmallIcon", this.ui.getClose().getIcon());
        closeAction.putValue("ShortDescription", this.ui.getClose().getToolTipText());
        this.ui.getClose().setAction(closeAction);
        JRootPane rootPane = this.ui.getRootPane();
        rootPane.setDefaultButton(this.ui.getClose());
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), CLOSE_ACTION);
        rootPane.getActionMap().put(CLOSE_ACTION, closeAction);
    }

    public static AboutUIBuilder builder(Frame parent) {
        return new AboutUIBuilder(parent);
    }

    public AboutUIBuilder setTitle(String title) {
        this.ui.getTitleLabel().setText(title);
        return this;
    }

    public AboutUIBuilder setIconPath(String iconPath) {
        this.ui.setIconPath(iconPath);
        if (iconPath != null) {
            ImageIcon logoIcon = Resource.getIcon((String)iconPath);
            this.ui.getTopPanel().add(new JLabel(logoIcon));
        }
        return this;
    }

    public AboutUIBuilder setBottomText(String bottomText) {
        this.ui.getBottomLabel().setText(bottomText);
        return this;
    }

    public AboutUIBuilder addAboutTab(String aboutText, boolean html) {
        return this.addTab0(I18n.t((String)"aboutframe.about", (Object[])new Object[0]), aboutText, html);
    }

    public AboutUIBuilder addDefaultLicenseTab(String projectName, boolean html) {
        return this.addLicenseTab("META-INF/" + projectName + "-LICENSE.txt", html);
    }

    public AboutUIBuilder addLicenseTab(String resourceName, boolean html) {
        String tabContent = this.load(resourceName);
        this.addTab0(I18n.t((String)"aboutframe.license", (Object[])new Object[0]), tabContent, html);
        return this;
    }

    public AboutUIBuilder addDefaultThirdPartyTab(String projectName, boolean html) {
        return this.addThirdPartyTab("META-INF/" + projectName + "-THIRD-PARTY.txt", html);
    }

    public AboutUIBuilder addThirdPartyTab(String resourceName, boolean html) {
        String tabContent = this.load(resourceName);
        return this.addTab0(I18n.t((String)"aboutframe.thirdparty", (Object[])new Object[0]), tabContent, html);
    }

    public AboutUIBuilder addDefaultChangelogTab(String projectName, boolean html) {
        return this.addChangelogTab("META-INF/" + projectName + "-CHANGELOG.txt", html);
    }

    public AboutUIBuilder addChangelogTab(String resourceName, boolean html) {
        String tabContent = this.load(resourceName);
        return this.addTab0(I18n.t((String)"aboutframe.changelog", (Object[])new Object[0]), tabContent, html);
    }

    public AboutUIBuilder addTab(String tabTitle, String tabContent, boolean html) {
        return this.addTab0(tabTitle, tabContent, html);
    }

    public AboutUIBuilder addTabFromResource(String tabTitle, String resourceName, boolean html) {
        String tabContent = this.load(resourceName);
        return this.addTab0(tabTitle, tabContent, html);
    }

    public AboutUIBuilder addTab(String tabTitle, JComponent component) {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(null);
        this.ui.tabs.addTab(tabTitle, component);
        return this;
    }

    public AboutUI build() {
        return this.ui;
    }

    protected AboutUIBuilder addTab0(String tabTitle, String tabContent, boolean html) {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(null);
        JTabbedPane tabs = this.ui.getTabs();
        tabs.addTab(tabTitle, scrollPane);
        final JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setBorder(null);
        if (html) {
            jEditorPane.setContentType("text/html");
        }
        jEditorPane.setText(tabContent);
        jEditorPane.setEditable(false);
        jEditorPane.setFont(jEditorPane.getFont().deriveFont(11.0f));
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                SwingUtil.openLink((HyperlinkEvent)e);
            }
        });
        scrollPane.getViewport().add(jEditorPane);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jEditorPane.setCaretPosition(0);
            }
        });
        return this;
    }

    protected String load(String resourceName) {
        String result = null;
        try {
            result = Resources.asCharSource((URL)Resources.getResource((String)resourceName), (Charset)Charsets.UTF_8).read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result == null) {
            result = "resource " + resourceName + " not found";
        }
        return result;
    }
}

