/*
 * #%L
 * JAXX :: Validator
 * 
 * $Id: SwingValidatorMessage.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.4/jaxx-validator/src/main/java/jaxx/runtime/validator/swing/SwingValidatorMessage.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.validator.swing;

import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.BeanValidatorMessage;

import javax.swing.JComponent;

/**
 * The object to box a validation message within an u.
 *
 * @author tchemit <chemit@codelutin.com>
 * @see BeanValidatorMessage
 * @since 1.3
 */
public class SwingValidatorMessage extends BeanValidatorMessage<SwingValidatorMessage> {

    private static final long serialVersionUID = 1L;

    /** the optional field's editor */
    protected JComponent editor;

    public SwingValidatorMessage(SwingValidator<?> validator,
                                 String fieldName,
                                 String message,
                                 NuitonValidatorScope scope,
                                 JComponent editor) {
        super(validator, fieldName, message, scope);
        this.editor = editor;
    }

    public JComponent getEditor() {
        return editor;
    }

    /**
     * @return the field name
     * @deprecated since 2.3, will not be replaced
     */
    @Deprecated
    public String getFieldName() {
        return getField();
    }

//    @Override
//    public int compareTo(SwingValidatorMessage o) {
//        // sort on scope
//        int result = getScope().compareTo(o.getScope());
//        if (result == 0) {
//            // sort on field name
//            result = fieldName.compareTo(o.getField());
//            if (result == 0) {
//                // sort on message
//                result = message.compareTo(o.getMessage());
//            }
//        }
//        return result;
//    }

//    @Override
//    public boolean equals(Object o) {
//        if (this == o) {
//            return true;
//        }
//        if (o == null || getClass() != o.getClass()) {
//            return false;
//        }
//
//        SwingValidatorMessage that = (SwingValidatorMessage) o;
//
//        return fieldName.equals(that.fieldName) &&
//               message.equals(that.message) &&
//               scope == that.scope;
//    }

//    @Override
//    public int hashCode() {
//        int result = fieldName.hashCode();
//        result = 31 * result + message.hashCode();
//        result = 31 * result + scope.hashCode();
//        return result;
//    }

    @Override
    public String toString() {
        String s = scope + " - " +
                   (field == null ? message : field + " - " + message);
        if (editor == null) {
            return s;
        }
        return editor.getName() + " : " + s;
    }
}
