/*
 * #%L
 * JAXX :: Validator
 * 
 * $Id: AbstractBeanValidatorUI.java 2144 2010-12-30 13:06:21Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.5/jaxx-validator/src/main/java/jaxx/runtime/validator/swing/ui/AbstractBeanValidatorUI.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.validator.swing.ui;

import jaxx.runtime.validator.BeanValidatorEvent;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

import javax.swing.JComponent;

/**
 * Abstract renderer
 *
 * @author tchemit <chemit@codelutin.com>
 */
public abstract class AbstractBeanValidatorUI extends AbstractLayerUI<JComponent> implements BeanValidatorListener {

    /** Logger */
    private static final Log log = LogFactory.getLog(AbstractBeanValidatorUI.class);

    /** the field to render */
    protected BeanValidatorField<?> field;

    public AbstractBeanValidatorUI(BeanValidatorField<?> field) {
        this.field = field;
        if (log.isDebugEnabled()) {
            log.debug("install " + this + "<field:" + field + ">");
        }
    }

    @Override
    public void onFieldChanged(BeanValidatorEvent event) {
        if (field.equals(event.getField())) {
            // ask to repaint the layer
            setDirty(true);
        }
    }

}
