/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwingValidatorMessageListMouseListener
extends MouseAdapter {
    private static Log log = LogFactory.getLog(SwingValidatorMessageListMouseListener.class);

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getClickCount() == 2) {
            SwingValidatorMessage entry = this.getSelectedMessage(e);
            if (entry == null) {
                return;
            }
            JComponent component = entry.getEditor();
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    protected SwingValidatorMessage getSelectedMessage(MouseEvent e) {
        JList list = (JList)e.getSource();
        if (!(list.getModel() instanceof SwingValidatorMessageListModel)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("model must be a " + SwingValidatorMessageListModel.class + ", but was " + list.getModel()));
            }
            return null;
        }
        SwingValidatorMessageListModel model = (SwingValidatorMessageListModel)list.getModel();
        int index = list.getSelectionModel().getMinSelectionIndex();
        if (index == -1) {
            return null;
        }
        SwingValidatorMessage entry = (SwingValidatorMessage)model.getElementAt(index);
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected index: " + index + " : error: " + entry));
        }
        return entry;
    }
}

