/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.field;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldExpressionValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Deprecated
public class CollectionUniqueKeyValidator
extends FieldExpressionValidator {
    protected String collectionFieldName;
    protected String[] keys;
    protected String againstProperty;
    protected boolean againstMe;
    protected String againstIndexExpression;

    public String getCollectionFieldName() {
        return this.collectionFieldName;
    }

    public void setCollectionFieldName(String collectionFieldName) {
        this.collectionFieldName = collectionFieldName;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public boolean getAgainstMe() {
        return this.againstMe;
    }

    public void setKeys(String[] keys) {
        this.keys = keys != null && keys.length == 1 && keys[0].indexOf(44) != -1 ? keys[0].split(",") : keys;
    }

    public String getAgainstProperty() {
        return this.againstProperty;
    }

    public void setAgainstProperty(String againstProperty) {
        this.againstProperty = againstProperty;
    }

    public String getAgainstIndexExpression() {
        return this.againstIndexExpression;
    }

    public void setAgainstIndexExpression(String againstIndexExpression) {
        this.againstIndexExpression = againstIndexExpression;
    }

    public void setAgainstMe(boolean againstMe) {
        this.againstMe = againstMe;
    }

    public void validate(Object object) throws ValidationException {
        Integer againstHashCode;
        Integer againstIndex;
        Object againstBean;
        if (this.keys == null || this.keys.length == 0) {
            throw new ValidationException("no unique keys defined");
        }
        String fieldName = this.getFieldName();
        Collection<?> col = this.getCollection(object);
        if (this.log.isDebugEnabled()) {
            this.log.debug("collection found : " + col, new String[0]);
        }
        Object object2 = againstBean = this.againstProperty == null ? null : this.getFieldValue(this.againstProperty, object);
        if (this.log.isDebugEnabled()) {
            this.log.debug("againtBean = " + againstBean, new String[0]);
        }
        Integer n = againstIndex = this.againstIndexExpression == null ? Integer.valueOf(-1) : this.getFieldValue(this.againstIndexExpression, object);
        if (againstIndex == null) {
            againstIndex = -1;
        }
        if (againstBean == null && col.size() < 2) {
            return;
        }
        if (this.againstMe) {
            againstBean = object;
            if (this.log.isDebugEnabled()) {
                this.log.debug("againtBean from me = " + againstBean, new String[0]);
            }
        }
        boolean answer = true;
        Integer n2 = againstHashCode = againstBean == null ? null : this.getUniqueKeyHashCode(againstBean);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hash for new key " + againstHashCode, new String[0]);
        }
        ArrayList<Integer> hashCodes = new ArrayList<Integer>();
        int index = 0;
        for (Object o : col) {
            Integer hash = this.getUniqueKeyHashCode(o);
            if (this.log.isDebugEnabled()) {
                this.log.debug("hash for object  " + o + " = " + hash, new String[0]);
            }
            if (againstBean == null) {
                if (hashCodes.contains(hash)) {
                    answer = false;
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Found same hashcode, not unique!", new String[0]);
                    break;
                }
            } else if (againstIndex != -1) {
                if (index != againstIndex && hash.equals(againstHashCode)) {
                    answer = false;
                    break;
                }
            } else if (!againstBean.equals(o) && hash.equals(againstHashCode)) {
                answer = false;
                break;
            }
            hashCodes.add(hash);
            ++index;
        }
        if (!answer) {
            this.addFieldError(fieldName, object);
        }
    }

    protected Integer getUniqueKeyHashCode(Object o) throws ValidationException {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (String key : this.keys) {
            Object property = this.getFieldValue(key, o);
            builder.append(property);
        }
        return builder.toHashCode();
    }

    protected Collection<?> getCollection(Object object) throws ValidationException {
        String fieldName = this.getCollectionFieldName();
        if (fieldName == null || fieldName.trim().isEmpty()) {
            fieldName = this.getFieldName();
        }
        Object obj = null;
        try {
            obj = this.getFieldValue(fieldName, object);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (obj == null) {
            return Collections.EMPTY_LIST;
        }
        if (!Collection.class.isInstance(obj)) {
            throw new ValidationException("field " + fieldName + " is not a collection type! (" + obj.getClass() + ')');
        }
        return (Collection)obj;
    }

    public String getValidatorType() {
        return "collectionUniqueKey";
    }
}

