package jaxx.demo.config;

import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import java.util.Arrays;
import java.util.Date;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.2
 */
public class RunDemo {

    /** Logger */
    private static Log log = LogFactory.getLog(RunDemo.class);

    /** The singleton instance of the main context */
    protected static DefaultApplicationContext context;

    public static void main(String[] args) {

        log.info("JAXX Demo start at " + new Date() + " args: " + Arrays.toString(args));

        try {

            I18n.setInitializer(new DefaultI18nInitializer("jaxx-tutorial-config-i18n"));

            // init config
            DemoConfig config = new DemoConfig();

            // init i18n
            I18n.init(config.getLocale());

            // prepare ui look&feel and load ui properties

            try {
                SwingUtil.initNimbusLoookAndFeel();
            } catch (Exception e) {
                // could not find nimbus look-and-feel
                log.warn(_("jaxxdemo.warning.nimbus.landf"));
            } catch (Throwable e) {
                log.warn(_("jaxxdemo.warning.no.ui"));
            }

            // instanciate config helper
            ConfigUIHelper helper = new ConfigUIHelper(config);

            // build the config ui
            buildConfigUI(helper);

            // display it
            JFrame parentUI = new JFrame();
            
            helper.displayUI(parentUI, false);

            // will force quit after quitting config ui
            parentUI.dispose();

        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    public static void buildConfigUI(ConfigUIHelper helper) {

        Runnable reloadUICallback = new Runnable() {

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info("will say Hello world");
                }
                JOptionPane.showMessageDialog(null, "Hello World!");
            }
        };

        Runnable reloadApplicationCallback = new Runnable() {

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info("will reload appplication");
                }
                if (log.isInfoEnabled()) {
                    log.info("will say Good Bye world");
                }
                JOptionPane.showMessageDialog(null, "Good Bye World!");
            }
        };

        helper.registerCallBack("ui",
                                n_("demo.action.reload.ui"),
                                SwingUtil.createActionIcon("reload-ui"),
                                reloadUICallback);

        helper.registerCallBack("application",
                                n_("demo.action.reload.application"),
                                SwingUtil.createActionIcon("reload-application"),
                                reloadApplicationCallback);

        // categorie repertoires

        helper.addCategory(n_("jaxxdemo.config.category.directories"),
                           n_("jaxxdemo.config.category.directories.description"));

        helper.addOption(DemoConfig.Option.CONFIG_FILE);

        // others
        helper.addCategory(n_("jaxxdemo.config.category.other"),
                           n_("jaxxdemo.config.category.other.description"));

        helper.addOption(DemoConfig.Option.FULL_SCREEN);
        helper.setOptionPropertyName(DemoConfig.PROPERTY_FULLSCREEN);
        helper.setOptionCallBack("ui");

        helper.addOption(DemoConfig.Option.FONT_SIZE);
        helper.setOptionPropertyName(DemoConfig.PROPERTY_FONT_SIZE);
        helper.setOptionCallBack("application");

        helper.addOption(DemoConfig.Option.LOCALE);
        helper.setOptionPropertyName(DemoConfig.PROPERTY_LOCALE);
        helper.setOptionCallBack("ui");

        helper.buildUI(new JAXXInitialContext(),
                                     "jaxxdemo.config.category.other");

    }

}
