package org.nuiton.jaxx.swing.extra;

import org.nuiton.jaxx.runtime.api.swing.Item;
import org.nuiton.jaxx.runtime.api.swing.JAXXComboBox;
import org.nuiton.jaxx.swing.extra.combobox.JaxxDefaultComboBoxModel;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Created on 4/6/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.0
 */
public class JComboBoxes {
    /**
     * Fill a combo box model with some datas, and select after all the given object
     *
     * @param combo  the combo to fill
     * @param data   data ot inject in combo
     * @param select the object to select in combo after reflling his model
     */
    public static void fillComboBox(JComboBox combo, Collection<?> data,
                                    Object select) {

        ComboBoxModel comboBoxModel = combo.getModel();

        if (comboBoxModel instanceof JaxxDefaultComboBoxModel) {
            JaxxDefaultComboBoxModel model =
                    (JaxxDefaultComboBoxModel) comboBoxModel;

            // evince the model
            model.removeListDataListener(combo);

            // set data
            model.setAllElements((Collection) data);

            // attach the model
            model.addListDataListener(combo);
            model.setSelectedItem(select);
        } else if (comboBoxModel instanceof DefaultComboBoxModel) {
            DefaultComboBoxModel model = (DefaultComboBoxModel) combo.getModel();
            // evince the model
            model.removeListDataListener(combo);
            model.removeAllElements();
            if (data != null) {
                for (Object o : data) {
                    model.addElement(o);
                }
            }
            // attach the model
            model.addListDataListener(combo);
            model.setSelectedItem(select);
        } else {
            throw new IllegalArgumentException(
                    "this method need a DefaultComboBoxModel for " +
                    "this model but was " + combo.getModel().getClass());
        }

    }

    /**
     * TODO move this to JAXXComboBox.
     * <p/>
     * Fill a combo box model with some datas, and select after all the given object
     *
     * @param combo     the combo to fill
     * @param data      data ot inject in combo
     * @param select    the object to select in combo after reflling his model
     * @param firstNull add a first null element
     * @deprecated since 1.7.XXX this code is moved to JAXXComboBox
     */
    @Deprecated
    public static void fillComboBox(JAXXComboBox combo,
                                    Collection<?> data,
                                    Object select, boolean firstNull) {
        List<Item> items = new ArrayList<Item>();
        if (firstNull) {
            items.add(new Item("null", " ", null, false));
        }
        if (data != null) {
            for (Object d : data) {
                Item item = new Item(d.toString(), d.toString(), d,
                                     d.equals(select));
                items.add(item);
            }
        }
        combo.setItems(items);
    }

    public static DefaultComboBoxModel newComboModel(Object... items) {
        return new DefaultComboBoxModel(items);
    }
}
