/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.action.ActionNameProvider;
import org.nuiton.jaxx.action.ActionProvider;
import org.nuiton.jaxx.action.MyAbstractAction;

public class ActionProviderFromProperties<A extends MyAbstractAction>
implements ActionProvider<A> {
    protected static final String ACTION_KEY_PREFIX = "action.";
    protected static final String actionsFileLocation = "META-INF/jaxx-%1$s-actions.properties";
    protected String propertiesPath;
    protected static Log log = LogFactory.getLog(ActionProviderFromProperties.class);
    protected Class<A> baseClass;
    protected Map<String, Class<? extends A>> actions;

    protected ActionProviderFromProperties(Class<A> baseClass) {
        this.baseClass = baseClass;
        this.propertiesPath = "/" + String.format(actionsFileLocation, baseClass.getSimpleName());
        this.actions = this.initCache();
    }

    @Override
    public Class<A> getBaseClass() {
        return this.baseClass;
    }

    @Override
    public Map<String, Class<? extends A>> getClasses() {
        return this.actions;
    }

    public String toString() {
        return super.toString() + "<baseClass:" + this.baseClass.getSimpleName() + ">";
    }

    protected void clearCache() {
        if (this.actions != null) {
            this.actions.clear();
            this.actions = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clearCache();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Class<? extends A>> initCache() {
        Properties properties;
        block14: {
            InputStream inputStream = null;
            properties = new Properties();
            try {
                inputStream = this.getClass().getResourceAsStream(this.propertiesPath);
                if (inputStream != null) {
                    log.info((Object)("load " + this.propertiesPath));
                    properties.load(inputStream);
                }
                if (inputStream == null) break block14;
            }
            catch (IOException e) {
                try {
                    String message = I18n._((String)"jaxx.error.load.actions.file", (Object[])new Object[]{e.getMessage()});
                    log.warn((Object)message);
                    throw new RuntimeException(message);
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        log.warn((Object)I18n._((String)"jaxx.error.close.actions.file", (Object[])new Object[]{e2.getMessage()}));
                    }
                    throw throwable;
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.warn((Object)I18n._((String)"jaxx.error.close.actions.file", (Object[])new Object[]{e.getMessage()}));
            }
        }
        TreeMap<String, Class<A>> cache = new TreeMap<String, Class<A>>();
        int prefix = ACTION_KEY_PREFIX.length();
        Iterator<Map.Entry<Object, Object>> i$ = properties.entrySet().iterator();
        block10: while (i$.hasNext()) {
            Map.Entry<Object, Object> entry = i$.next();
            String key = entry.getKey() + "";
            String qfn = entry.getValue() + "";
            try {
                Class<?> implCass = Class.forName(qfn);
                String actionKey = key.substring(prefix);
                if (actionKey.startsWith(":")) {
                    Class<?> klazz = Class.forName(actionKey.substring(1));
                    String[] arr$ = ((ActionNameProvider)klazz.newInstance()).getActionCommands();
                    int len$ = arr$.length;
                    int i$2 = 0;
                    while (true) {
                        if (i$2 >= len$) continue block10;
                        String s = arr$[i$2];
                        log.debug((Object)("found action <" + s + " : " + implCass + ">"));
                        cache.put(s, implCass);
                        ++i$2;
                    }
                }
                log.debug((Object)("found action <" + actionKey + " : " + implCass + ">"));
                cache.put(actionKey, implCass);
            }
            catch (Exception e) {
                throw new RuntimeException(I18n._((String)"jaxx.error.load.actions.class", (Object[])new Object[]{key, qfn}), e);
            }
        }
        return cache;
    }
}

