/*
 * *##% 
 * JAXX Action
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.action;

import javax.swing.JComponent;

/**
 * Common abstract class of a resolver of action configuration.
 * <p/>
 * The class implements the logic of research of the configuration annotation.
 *
 * @param <A> type of annotation
 * @param <C> type of component
 * @author chemit
 */
public abstract class AbstractActionConfigurationResolver<A extends java.lang.annotation.Annotation, C extends JComponent> implements ActionConfigurationResolver<A, C> {

    /** the type of configuration's annotation */
    protected final Class<A> annotationImpl;

    /** the type of component that can fire an action */
    protected final Class<C> componentImpl;

    /**
     * The typed method (on component) to apply configuration on the action and component.
     *
     * @param component the component which fires the action
     * @param action    the given action
     * @return the configuration's annotation
     */
    protected abstract A applyConfiguration0(C component, MyAbstractAction action);

    protected AbstractActionConfigurationResolver(Class<A> annotationImpl, Class<C> componentImpl) {
        this.annotationImpl = annotationImpl;
        this.componentImpl = componentImpl;
    }

    @Override
    public A resolveConfiguration(MyAbstractAction action) {
        if (action.hasDelegate()) {
            return resolveConfiguration(action.getDelegate());
        }
        return action.getClass().getAnnotation(annotationImpl);
    }

    @SuppressWarnings({"unchecked"})
    @Override
    public A applyConfiguration(JComponent component, MyAbstractAction action) {
        if (component != null && componentImpl.isAssignableFrom(component.getClass())) {
            return applyConfiguration0((C) component, action);
        }

        return null;
    }

    @Override
    public Class<A> getAnnotationImpl() {
        return annotationImpl;
    }

    @Override
    public Class<C> getComponentImpl() {
        return componentImpl;
    }
}
