/*
 * *##% 
 * JAXX Action
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.util;

/** @author chemit */
public abstract class UIProvider {

    /** the name of application using this provider */
    protected String applicationName;

    /** the name of ui implementation used by this provider */
    protected String providerName;

    /** array of ui implementations */
    protected Class<?>[] implementations;

    protected UIProvider(String applicationName, String providerName, Class<?>... implementations) {
        this.applicationName = applicationName;
        this.providerName = providerName;
        this.implementations = implementations;
    }

    public String getProviderName() {
        return providerName;
    }

    public String getApplicationName() {
        return applicationName;
    }

    public Class<?>[] getImplementations() {
        return implementations;
    }

    public Class<?> findUIImplementation(DialogUIDef<?, ?, ?> def) {
        Class<? extends DialogUI<?>> uiClass = def.getUiClass();
        for (Class<?> klass : implementations) {
            if (uiClass.isAssignableFrom(klass)) {
                def.setUiImplClass(klass);
                return klass;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append('<');
        sb.append(printClass("application", applicationName, true));
        sb.append(printClass("provider", providerName, true));
        sb.append(printClass("uis", implementations.length, false));
        return sb.toString();
    }

    protected String printClass(String s, Object aClass, boolean notLast) {
        return s + ':' + (aClass == null ? null : aClass) + (notLast ? ", " : ">");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof UIProvider)) return false;

        UIProvider that = (UIProvider) o;
        return applicationName.equals(that.applicationName) && providerName.equals(that.providerName);

    }

    @Override
    public int hashCode() {
        return (31 * applicationName.hashCode()) + providerName.hashCode();
    }

}