/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: VBoxBeanInfo.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.1/jaxx-runtime/src/main/java/jaxx/runtime/swing/VBoxBeanInfo.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import javax.swing.JPanel;
import javax.swing.SwingConstants;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public class VBoxBeanInfo extends SimpleBeanInfo {

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        try {
            return new BeanInfo[]{Introspector.getBeanInfo(JPanel.class)};
        } catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        try {
            PropertyDescriptor spacing = new PropertyDescriptor("spacing", VBox.class);
            spacing.setBound(true);

            PropertyDescriptor margin = new PropertyDescriptor("margin", VBox.class);
            margin.setBound(true);

            PropertyDescriptor horizontalAlignment = new PropertyDescriptor("horizontalAlignment", VBox.class);
            horizontalAlignment.setBound(true);
            horizontalAlignment.setValue("enumerationValues", new Object[]{
                    "left", SwingConstants.LEFT, "SwingConstants.LEFT",
                    "center", SwingConstants.CENTER, "SwingConstants.CENTER",
                    "right", SwingConstants.RIGHT, "SwingConstants.RIGHT"
            });

            PropertyDescriptor verticalAlignment = new PropertyDescriptor("verticalAlignment", VBox.class);
            verticalAlignment.setBound(true);
            verticalAlignment.setValue("enumerationValues", new Object[]{
                    "top", SwingConstants.TOP, "SwingConstants.TOP",
                    "middle", SwingConstants.CENTER, "SwingConstants.CENTER",
                    "bottom", SwingConstants.BOTTOM, "SwingConstants.BOTTOM"
            });

            return new PropertyDescriptor[]{spacing, margin, horizontalAlignment, verticalAlignment};
        } catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }
}
