/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.swing.ui.AbstractBeanValidatorUI;
import org.jdesktop.jxlayer.JXLayer;

public class TranslucentValidationUI
extends AbstractBeanValidatorUI {
    protected Color errorHightlight = Color.RED;
    protected Color warningHightlight = Color.YELLOW;
    protected Color infoHightlight = Color.GREEN;

    public TranslucentValidationUI(BeanValidatorField<?> field) {
        super(field);
    }

    protected void paintLayer(Graphics2D g2, JXLayer<JComponent> l) {
        super.paintLayer(g2, l);
        Insets layerInsets = l.getInsets();
        g2.translate(layerInsets.left, layerInsets.top);
        JComponent view = l.getView();
        Insets insets = view.getInsets();
        g2.clip(new Rectangle(insets.left, insets.top, view.getWidth() - insets.left - insets.right, view.getHeight() - insets.top - insets.bottom));
        BeanValidatorScope scope = this.field.getScope();
        if (scope == null) {
            g2.setColor(Color.WHITE);
        } else {
            switch (scope) {
                case ERROR: {
                    g2.setColor(this.errorHightlight);
                    break;
                }
                case WARNING: {
                    g2.setColor(this.warningHightlight);
                    break;
                }
                case INFO: {
                    g2.setColor(this.infoHightlight);
                }
            }
        }
        g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g2.fillRect(0, 0, l.getWidth(), l.getHeight());
    }
}

