/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.SwingWorker;
import jaxx.runtime.swing.application.ActionWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public abstract class AbstractActionThread
extends Thread {
    private static final Log log = LogFactory.getLog(AbstractActionThread.class);
    private boolean canceled;
    private final Object LOCK = new Object();
    protected ActionWorker worker;
    protected final PropertyChangeListener workerListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("action " + evt.getSource() + " property " + evt.getPropertyName() + " changed <" + evt.getOldValue() + " - " + evt.getNewValue() + '>'));
            }
            if (!"state".equals(evt.getPropertyName())) return;
            ActionWorker source = (ActionWorker)evt.getSource();
            SwingWorker.StateValue state = (SwingWorker.StateValue)((Object)evt.getNewValue());
            if (state == SwingWorker.StateValue.STARTED) {
                AbstractActionThread.this.onActionStart(source);
                return;
            }
            if (state != SwingWorker.StateValue.DONE) return;
            ActionWorker.ActionStatus status = source.getStatus();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Action [" + source.getActionLabel() + "] status = " + (Object)((Object)status)));
            }
            try {
                switch (status) {
                    case OK: {
                        AbstractActionThread.this.onActionEnd(source);
                        return;
                    }
                    case CANCEL: {
                        AbstractActionThread.this.onActionCancel(source);
                        return;
                    }
                    case FAIL: {
                        AbstractActionThread.this.onActionFail(source);
                        return;
                    }
                }
                return;
            }
            finally {
                AbstractActionThread.this.setWaiting(false);
            }
        }
    };

    protected AbstractActionThread(String name) {
        super(name);
    }

    public Runnable createRunnable(final Object methodContainer, String methodName, final Object ... arguments) {
        Class<?> klass = methodContainer.getClass();
        Method mFound = null;
        for (Method m : klass.getDeclaredMethods()) {
            Class<?>[] types;
            if (!methodName.equals(m.getName()) || arguments.length != (types = m.getParameterTypes()).length) continue;
            mFound = m;
            break;
        }
        if (mFound == null) {
            throw new IllegalArgumentException("could not find method " + methodName + " on type " + klass.getName());
        }
        final Method targetMethod = mFound;
        targetMethod.setAccessible(true);
        Runnable result = (Runnable)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Runnable.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                String methodName = method.getName();
                if ("run".equals(methodName)) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"will invoke run method");
                        }
                        return targetMethod.invoke(methodContainer, arguments);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("could not invoke on container " + methodContainer, e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (methodName.equals("toString")) {
                    return this.toString();
                }
                if (methodName.equals("equals")) {
                    return this.equals(args[0]);
                }
                if (methodName.equals("hashCode")) {
                    return this.hashCode();
                }
                return null;
            }
        });
        return result;
    }

    public ActionWorker addAction(String actionLabel, Runnable action) {
        if (this.worker != null && !this.worker.isDone()) {
            throw new IllegalStateException("can not add a operation when thread is busy, or has another operation to be done");
        }
        this.worker = action instanceof ActionWorker ? (ActionWorker)action : new ActionWorker(actionLabel, action);
        this.setWaiting(false);
        return this.worker;
    }

    public abstract void onActionStart(ActionWorker var1);

    public abstract void onActionFail(ActionWorker var1);

    public abstract void onActionCancel(ActionWorker var1);

    public abstract void onActionEnd(ActionWorker var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (log.isInfoEnabled()) {
            log.info((Object)("starting... " + this));
        }
        try {
            while (!this.canceled) {
                if (this.canceled) {
                    return;
                }
                this.setWaiting(true);
                log.trace((Object)("no more waiting " + this));
                if (this.canceled) continue;
                try {
                    this.worker.addPropertyChangeListener(this.workerListener);
                    this.worker.execute();
                    this.setWaiting(true);
                }
                finally {
                    if (this.worker == null) continue;
                    this.worker.removePropertyChangeListener(this.workerListener);
                    this.worker = null;
                }
            }
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.unlockThread();
            if (log.isInfoEnabled()) {
                log.info((Object)(this + " will close..."));
            }
            this.close();
        }
    }

    public void cancel() {
        log.info((Object)("cancel " + this));
        this.canceled = true;
        this.setWaiting(false);
    }

    protected void close() {
        log.info((Object)this);
    }

    protected void setWaiting(boolean waiting) {
        if (waiting && !this.canceled) {
            try {
                this.lockThread();
            }
            catch (InterruptedException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                this.canceled = true;
            }
        }
        if (!waiting) {
            this.unlockThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockThread() throws InterruptedException {
        Object object = this.LOCK;
        synchronized (object) {
            log.trace((Object)this);
            this.LOCK.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockThread() {
        Object object = this.LOCK;
        synchronized (object) {
            log.trace((Object)this);
            this.LOCK.notify();
        }
    }
}

