/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.wizard;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingWorker;
import jaxx.runtime.swing.wizard.WizardModel;
import jaxx.runtime.swing.wizard.WizardOperationAction;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardOperationStep;

public class WizardOperationModel<E extends WizardOperationStep>
extends WizardModel<E> {
    public static final String OPERATIONS_PROPERTY_NAME = "operations";
    public static final String OPERATION_STATE_PROPERTY_NAME = "operationState";
    public static final String MODEL_STATE_PROPERTY_NAME = "modelState";
    public static final String WAS_STARTED_PROPERTY_NAME = "wasStarted";
    protected Set<E> operations;
    protected Map<E, WizardOperationState> operationStates;
    protected Map<E, WizardOperationAction<E, ? extends WizardOperationModel<E>>> operationActions;
    protected WizardOperationState modelState;
    protected boolean wasStarted;

    public <T extends Enum<T>> WizardOperationModel(Class<E> stepClass, E ... steps) {
        super(stepClass, steps);
        Class<E> k = stepClass;
        this.operationStates = new EnumMap<E, WizardOperationState>(k);
        this.operations = EnumSet.noneOf(k);
        this.operationActions = new EnumMap<E, WizardOperationAction<E, ? extends WizardOperationModel<E>>>(k);
    }

    public Set<E> getOperations() {
        return this.operations;
    }

    public WizardOperationState getModelState() {
        return this.modelState;
    }

    public boolean isWasStarted() {
        return this.wasStarted;
    }

    public E getOperation() {
        return (E)(this.getStep() != null && ((WizardOperationStep)this.getStep()).isOperation() ? (WizardOperationStep)this.getStep() : null);
    }

    public WizardOperationState getOperationState() {
        E operation = this.getOperation();
        return this.getOperationState(operation);
    }

    public WizardOperationState getOperationState(E operation) {
        return this.operationStates.get(operation);
    }

    public WizardOperationAction<E, ? extends WizardOperationModel<E>> getOperationAction(E operation) {
        WizardOperationAction<Object, WizardOperationModel<Object>> action = this.operationActions.get(operation);
        if (action == null) {
            try {
                action = operation.getActionClass().newInstance();
                this.operationActions.put(operation, action);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return action;
    }

    public void setOperationState(WizardOperationState operationState) {
        E operation = this.getOperation();
        this.setOperationState(operation, operationState);
    }

    public void setOperationState(E operation, WizardOperationState operationState) {
        WizardOperationState oldValue = this.getOperationState(operation);
        this.operationStates.put(operation, operationState);
        this.fireIndexedPropertyChange(OPERATION_STATE_PROPERTY_NAME, this.getSteps().indexOf(operation), (Object)oldValue, (Object)operationState);
        this.updateModelState(operation, operationState);
        this.validate();
    }

    public boolean[] getAccessibleSteps() {
        boolean[] result = new boolean[this.getSteps().size()];
        int index = this.getSteps().indexOf(this.getStep());
        if (index != -1) {
            int j = this.steps.size();
            for (int i = 0; i < j; ++i) {
                if (i <= index) {
                    result[i] = true;
                    continue;
                }
                WizardOperationStep previousStep = (WizardOperationStep)this.steps.get(i - 1);
                result[i] = this.modelState == WizardOperationState.SUCCESSED || result[i - 1] && this.validate(previousStep) && (!previousStep.isOperation() || this.getOperationState(previousStep) == WizardOperationState.SUCCESSED);
            }
        }
        return result;
    }

    @Override
    public void start() {
        super.start();
        this.updateUniverse();
        this.setModelState(WizardOperationState.PENDING);
    }

    public void cancel() {
        WizardOperationAction<WizardOperationStep, WizardOperationModel<WizardOperationStep>> action;
        for (WizardOperationStep op : this.operations) {
            if (this.getOperationState(op) != WizardOperationState.PENDING) continue;
            this.setOperationState(op, WizardOperationState.CANCELED);
        }
        this.setModelState(WizardOperationState.CANCELED);
        if (this.getStep() != null && ((WizardOperationStep)this.getStep()).isOperation() && (action = this.getOperationAction((WizardOperationStep)this.getStep())) != null && !action.isCancelled() && !action.isDone() && action.getState() == SwingWorker.StateValue.STARTED) {
            action.cancel(true);
        }
    }

    public WizardOperationModel<E> addOperation(E operation) {
        this.operations.add(operation);
        this.updateUniverse();
        this.validate();
        return this;
    }

    public void removeOperation(E operation) {
        this.operations.remove(operation);
        this.updateUniverse();
        this.validate();
    }

    @Override
    public void setSteps(E ... steps) {
        super.setSteps(steps);
        this.firePropertyChange(OPERATIONS_PROPERTY_NAME, null, this.operations);
        this.updateOperationStates(Arrays.asList(steps));
    }

    public void updateOperationStates(List<E> steps) {
        int index = 0;
        for (WizardOperationStep e : steps) {
            this.fireIndexedPropertyChange(OPERATION_STATE_PROPERTY_NAME, index++, null, (Object)this.getOperationState(e));
        }
        this.firePropertyChange(MODEL_STATE_PROPERTY_NAME, null, (Object)this.modelState);
    }

    public WizardOperationAction<E, ? extends WizardOperationModel<E>> reloadOperation(E operation) {
        this.operationActions.remove(operation);
        WizardOperationAction<E, WizardOperationModel<E>> newOp = this.getOperationAction(operation);
        return newOp;
    }

    protected void setModelState(WizardOperationState modelState) {
        WizardOperationState oldValue = this.modelState;
        this.modelState = modelState;
        this.firePropertyChange(MODEL_STATE_PROPERTY_NAME, (Object)oldValue, (Object)modelState);
        if (!(this.wasStarted || oldValue != null && oldValue != WizardOperationState.PENDING || modelState != WizardOperationState.RUNNING)) {
            this.wasStarted = true;
            this.firePropertyChange(WAS_STARTED_PROPERTY_NAME, false, true);
        }
    }

    protected void updateModelState(E operation, WizardOperationState operationState) {
        switch (operationState) {
            case RUNNING: {
                this.setModelState(WizardOperationState.RUNNING);
                break;
            }
            case FAILED: {
                this.setModelState(WizardOperationState.FAILED);
                break;
            }
            case CANCELED: {
                this.setModelState(WizardOperationState.CANCELED);
                return;
            }
            case PENDING: {
                this.setModelState(WizardOperationState.PENDING);
                break;
            }
            case NEED_FIX: {
                this.setModelState(WizardOperationState.PENDING);
                break;
            }
            case SUCCESSED: {
                boolean valid = true;
                for (WizardOperationStep o : this.operations) {
                    if (this.getOperationState(o) == WizardOperationState.SUCCESSED) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    this.setModelState(WizardOperationState.SUCCESSED);
                    break;
                }
                this.setModelState(WizardOperationState.PENDING);
            }
        }
        this.updateOperationStates(this.steps);
    }

    @Override
    protected void updateUniverse() {
        WizardOperationStep[] newSteps = (WizardOperationStep[])this.updateStepUniverse();
        this.setSteps(newSteps);
    }

    protected int getOperationIndex(E operation) {
        int index = 0;
        for (WizardOperationStep o : this.operations) {
            if (o.equals(operation)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

