/*
 * *##% 
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime.swing.wizard;

/**
 * Le contrat a implanter pour une etapes dans le modèle de wizard avec
 * opérations.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public interface WizardOperationStep extends WizardStep {

    /** @return le label de l'opération */
    String getOperationLabel();

    /** @return la description de l'opération */
    String getOperationDescription();

    /**
     * @return le type de l'action associée à l'étape ou <code>null</code> si
     *         l'étape n'a pas d'opération associée.
     */
    Class<? extends WizardOperationAction<?, ?>> getActionClass();

    /**
     * @return <code>true</code> si l'étape a une opération associée,
     *         <code>false</code> sinon.
     */
    boolean isOperation();
}
