package jaxx.runtime.swing.editor.config;

import jaxx.runtime.swing.editor.config.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.config.model.*;
import jaxx.runtime.swing.editor.ColumnSelector;
import static org.nuiton.i18n.I18n.n_;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigCategoryUI extends javax.swing.JPanel implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.config.ConfigCategoryUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuHF+uUlD0jYgKDguqhypXSdQqYhUBcekiqtNXNlOWpJDmHgnzpTxzjI7Gzu1ipA4gRDqiQMX4M6RO0I9cuLK/4AQ/wFvZte7XnvBQeSwsd++73s/5n1v/OMfKO0KtPwEdzqG8GxJW8R4UHz8uHL0hDTkB8RtCOpILpD/N5ZCqQOUsUK7K9H1A1PBCwG8UOIth9vE7kOvm2jGlWeMuCeESImu+IiG6xZqoXm943iixxYmk8T2/V9/pp5bn/2QQqjjQFZzUEJ2FCqqYNxEKWpJtACRTnGBYbsJaQhqNyHPWWUrMey6O7hFPkGfokkTTThYAJlEufOXqjk0vuNINPXmg4fYJmxVorVYpm4b4hrEooA1Gtw+pk3IXv0rYUmaXJztlh1HE01INNsIjNvcIkyi2yO5WsrRKPXDIroZiY8YCbjunJdLf6mHyIhuziUMpoZyO6B8XTWzE3CZ1JW1mEOEXOjVZeIjwnSnwNiP9tun3KeHu6FRgwBtVJ5XQsC0rlcxSbQUc641BGc6cDxEWiMGqXXxyuPV0LF3wGvq+1Kc5FJPL1B4L8Q19VgOXTJ9LqCPeDTSkUVBsHK9PhTwrTBgxJYWxFU6W4zxbHhSclu55EPPcRef6nxuBnahQDAHoE0j0mYknrEDYPfALNH8QSTjKph8AQdWTaCt333+7ek3P/38bk+tGYgxG3PpWy6gHkdwhwhJVYhLvkQ9SVlhGzvrB2janzG9eS73JVALzJAE8L+kYIaCGVvYPQFoevL3X15c/ei3Cyh1H80wjq37WPmXYShOoF0nnFkd5733dSYX21PwnFc5gUiOcOPjpuCeDTtjtlviDBTxaKtc33zWgXov99UbJvHr86+2X/v62p1ezWN+TgNuUd3pfTRBbUZtondTsHYSd1HGcYln8Wi9JC0clCgpJxDcbf18J6nY+QZnXsveItgiYo+StkS4a5N21pdT/jCfC5aBP7BqXnMrN+Pbd1f1vUnkbnkb27hJRFFrvgzIfI7ax1y0cA+4troCbVT53NV9Up/uoWHNjMo9Deo+5g3P9fWaPsYMJIDGJYhHomw3StzmBte0hj9KxMqtPNNoW95y6VNApdZgT0+p5TfAJngb5m7s7aSM+yU8KtsLiZ1+uavjqdbpDeO/y6vslk6VJBqY+YtqA4uHnNHGmUSFbrS7YDW7EtvSNfY2q/VyqWge1krVimluFKuHRfNR8cMacL1ywgV9CtUmsK0msm1VquX9yk49xrezCUESzy5as+fowxz2JK8S1Xh1Kaiz8verUdytVw6rm7Xy/iYkbx6WKubu9o6qYBHOIbxKiozxNrGiU1pUjCVYmJJUwY8LCb2DSRAeScrWX/GjMh2XaJLYyhMiLXfhiGJ3an7FoC58oseUWPrEgslbDKYO61yNYDHP4FAREl30XW4F7zKSc1anTl3jlxLwhqROYiX67X+qpDiqkuyNG9lElz3MaKzShXim6mIZKDQTFOq/itd5dRj9T2XqO+scu2yC4TMOdx6au2thibNH1LbgIrw3xDmmnjPnYBz4gaP8vkxme2MkmzJ/8S8Muf/NsAIMfwNboUOq4QsAAA==";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JLabel categoryLabel;
    protected javax.swing.JPanel categoryLabelPanel;
    protected jaxx.runtime.swing.editor.config.model.CategoryModel categoryModel;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JTextArea description;
    protected javax.swing.JScrollPane descriptionPane;
    protected javax.swing.JButton reset;
    protected javax.swing.JButton save;
    protected javax.swing.ListSelectionModel selectionModel;
    protected javax.swing.JTable table;
    protected jaxx.runtime.swing.editor.config.model.ConfigTableModel tableModel;
    protected javax.swing.JScrollPane tablePane;
    private jaxx.runtime.swing.editor.config.ConfigCategoryUI $JPanel0 = this;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JPanel $JPanel2;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($JPanel0, "reset.enabled");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($JPanel0, "save.enabled");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($JPanel0, "tablePane.columnHeaderView");

    /* begin raw body code */    
    
    void $afterCompleteSetup() {
        // prepare table
        SwingUtil.setI18nTableHeaderRenderer(table,
            n_("config.key"),
            n_("config.key.tip"),
            n_("config.value"),
            n_("config.value.tip"),
            n_("config.defaultValue"),
            n_("config.defaultValue.tip"));
    
        ConfigTableRenderer renderer = new ConfigTableRenderer();
        SwingUtil.setTableColumnRenderer(table, 0, renderer);
        SwingUtil.setTableColumnRenderer(table, 1, renderer);
        SwingUtil.setTableColumnRenderer(table, 2, renderer);
        Font f = table.getFont().deriveFont(Font.ITALIC | Font.BOLD);
        int width = SwingUtil.computeTableColumnWidth(table, f, 0, "___*");
        SwingUtil.fixTableColumnWidth(table, 0, width);
        SwingUtil.setTableColumnEditor(table, 1, new ConfigTableEditor((ConfigTableModel) table.getModel()));
        //TODO to be continued...
        //columnSelector.setMyTable(table);
        //tablePane.setCorner(ScrollPaneConstants.UPPER_RIGHT_CORNER, columnSelector);
    }
    
    protected void updateDescriptionText() {
        OptionModel option;
        if (selectionModel.isSelectionEmpty()) {
            option = null;
        } else {
            int row = selectionModel.getAnchorSelectionIndex();
            ConfigTableModel m = (ConfigTableModel) table.getModel();
            option = m.getEntry(row);
            if (log.isDebugEnabled()) {
                log.debug(row + " : " + option);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (option == null) {
            buffer.append(_("config.no.option.selected"));
        } else {
            buffer.append(_("config.option.label", option.getKey(), _(option.getDescription()))).append('\n');
            if (option.isModified()) {
                buffer.append(_("config.option.modified", option.getOriginalValue(), option.getValue())).append('\n');
            }
            if (option.isFinal()) {
                buffer.append(_("config.option.final")).append('\n');
            }
        }
        description.setText(buffer.toString());
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public ConfigCategoryUI() {
        $initialize();
    }

    public ConfigCategoryUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("tablePane.columnHeaderView".equals($binding)) {
            if (table != null) {
                table.addPropertyChangeListener("tableHeader", $DataSource8);
            }
        } else if ("reset.enabled".equals($binding)) {
                addPropertyChangeListener("categoryModel", $DataSource14);
        if (getCategoryModel() != null) {
                getCategoryModel().addPropertyChangeListener("modified", $DataSource14);
            }
        } else if ("save.enabled".equals($binding)) {
                addPropertyChangeListener("categoryModel", $DataSource16);
        if (getCategoryModel() != null) {
                getCategoryModel().addPropertyChangeListener("modified", $DataSource16);
            }if ( getCategoryModel() != null) {
                 getCategoryModel().addPropertyChangeListener("valid", $DataSource16);
            }
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("tablePane.columnHeaderView".equals($dest)) {
            if (table != null) {
                tablePane.setColumnHeaderView((table.getTableHeader()));
            }
            } else if ("reset.enabled".equals($dest)) {
            if (getCategoryModel() != null) {
                reset.setEnabled((getCategoryModel().isModified()));
            }
            } else if ("save.enabled".equals($dest)) {
            if ( getCategoryModel() != null) {
                save.setEnabled((getCategoryModel().isModified() && getCategoryModel().isValid()));
            }
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("tablePane.columnHeaderView".equals($binding)) {
            if (table != null) {
                table.removePropertyChangeListener("tableHeader", $DataSource8);
            }
        } else if ("reset.enabled".equals($binding)) {
                removePropertyChangeListener("categoryModel", $DataSource14);
        if (getCategoryModel() != null) {
                getCategoryModel().removePropertyChangeListener("modified", $DataSource14);
            }
        } else if ("save.enabled".equals($binding)) {
                removePropertyChangeListener("categoryModel", $DataSource16);
        if (getCategoryModel() != null) {
                getCategoryModel().removePropertyChangeListener("modified", $DataSource16);
            }if ( getCategoryModel() != null) {
                 getCategoryModel().removePropertyChangeListener("valid", $DataSource16);
            }
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__reset(java.awt.event.ActionEvent event) {
        getContextValue(ConfigUIModel.class).reset();
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        getContextValue(ConfigUIModel.class).saveModified();
    }

    public void doTableChanged__on__tableModel(javax.swing.event.TableModelEvent event) {
        updateDescriptionText();
    }

    public void doValueChanged__on__selectionModel(javax.swing.event.ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) { updateDescriptionText(); };
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public javax.swing.JPanel getCategoryLabelPanel() {
        return categoryLabelPanel;
    }

    public jaxx.runtime.swing.editor.config.model.CategoryModel getCategoryModel() {
        return categoryModel;
    }

    public javax.swing.JTextArea getDescription() {
        return description;
    }

    public javax.swing.JScrollPane getDescriptionPane() {
        return descriptionPane;
    }

    public javax.swing.JButton getReset() {
        return reset;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public javax.swing.ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public javax.swing.JTable getTable() {
        return table;
    }

    public jaxx.runtime.swing.editor.config.model.ConfigTableModel getTableModel() {
        return tableModel;
    }

    public javax.swing.JScrollPane getTablePane() {
        return tablePane;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setCategoryModel(jaxx.runtime.swing.editor.config.model.CategoryModel newValue) {
        jaxx.runtime.swing.editor.config.model.CategoryModel oldValue = this.categoryModel;
        this.categoryModel = newValue;
        firePropertyChange("categoryModel", oldValue, newValue);
    }

    public void setSelectionModel(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = newValue;
        firePropertyChange("selectionModel", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected jaxx.runtime.swing.editor.config.ConfigCategoryUI get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JPanel0.add(categoryLabelPanel, BorderLayout.NORTH);
        $JPanel0.add(tablePane, BorderLayout.CENTER);
        $JPanel0.add($JPanel1, BorderLayout.SOUTH);
        
        addChildrenToCategoryLabelPanel();
        addChildrenToTablePane();
        $JPanel1.add(descriptionPane, BorderLayout.CENTER);
        $JPanel1.add($JPanel2, BorderLayout.SOUTH);
        
        addChildrenToDescriptionPane();
        $JPanel2.add(reset);
        $JPanel2.add(save);
        
        table.setSelectionModel((selectionModel));
        categoryLabelPanel.setBackground((Color.WHITE));
        applyDataBinding("tablePane.columnHeaderView");
        tablePane.setVerticalScrollBarPolicy((ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS));
        tablePane.setHorizontalScrollBarPolicy((ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER));
        table.setAutoResizeMode((JTable.AUTO_RESIZE_ALL_COLUMNS));
        descriptionPane.setColumnHeaderView((new JLabel(_("config.descrition"), jaxx.runtime.Util.getUIManagerActionIcon("information"), 10)));
        jaxx.runtime.SwingUtil.setText(description, String.valueOf((_("config.no.option.selected"))));
        
        applyDataBinding("reset.enabled");
        reset.setIcon((jaxx.runtime.Util.createActionIcon("config-reset")));
        applyDataBinding("save.enabled");
        save.setIcon((jaxx.runtime.Util.createActionIcon("config-save")));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createCategoryModel();
        createTableModel();
        createSelectionModel();
        createCategoryLabelPanel();
        createCategoryLabel();
        createTablePane();
        createTable();
        
        $JPanel1 = new javax.swing.JPanel();
        $objectMap.put("$JPanel1", $JPanel1);
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout((new BorderLayout()));
        
        createDescriptionPane();
        createDescription();
        
        $JPanel2 = new javax.swing.JPanel();
        $objectMap.put("$JPanel2", $JPanel2);
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout((new GridLayout(1,0)));
        
        createReset();
        createSave();
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout((new BorderLayout()));
        
        
        $completeSetup();
    }

    protected void addChildrenToCategoryLabelPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryLabelPanel.add(categoryLabel);
    }

    protected void addChildrenToDescriptionPane() {
        if (!allComponentsCreated) {
            return;
        }
        descriptionPane.getViewport().add(description);
    }

    protected void addChildrenToTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        tablePane.getViewport().add(table);
    }

    protected void createCategoryLabel() {
        categoryLabel = new javax.swing.JLabel();
        $objectMap.put("categoryLabel", categoryLabel);
        categoryLabel.setName("categoryLabel");
    }

    protected void createCategoryLabelPanel() {
        categoryLabelPanel = new javax.swing.JPanel();
        $objectMap.put("categoryLabelPanel", categoryLabelPanel);
        categoryLabelPanel.setName("categoryLabelPanel");
    }

    protected void createCategoryModel() {
        categoryModel = getContextValue(CategoryModel.class);
        $objectMap.put("categoryModel", categoryModel);
    }

    protected void createDescription() {
        description = new javax.swing.JTextArea();
        $objectMap.put("description", description);
        description.setName("description");
        description.setColumns(15);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setFocusable(false);
        if (description.getFont() != null) description.setFont(description.getFont().deriveFont((float) 10));
        description.setEditable(false);
        description.setRows(3);
    }

    protected void createDescriptionPane() {
        descriptionPane = new javax.swing.JScrollPane();
        $objectMap.put("descriptionPane", descriptionPane);
        descriptionPane.setName("descriptionPane");
    }

    protected void createReset() {
        reset = new javax.swing.JButton();
        $objectMap.put("reset", reset);
        reset.setName("reset");
        reset.setText(_("config.action.reset"));
        reset.setToolTipText(_("config.action.reset.tip"));
        reset.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__reset"));
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
        save.setText(_("config.action.save"));
        save.setToolTipText(_("config.action.save.tip"));
        save.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JPanel0, "doActionPerformed__on__save"));
    }

    protected void createSelectionModel() {
        selectionModel = new DefaultListSelectionModel();
        $objectMap.put("selectionModel", selectionModel);
        selectionModel.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $JPanel0, "doValueChanged__on__selectionModel"));
    }

    protected void createTable() {
        table =  new javax.swing.JTable(tableModel);
        $objectMap.put("table", table);
        table.setName("table");
        table.setRowSelectionAllowed(false);
        table.setAutoCreateRowSorter(true);
    }

    protected void createTableModel() {
        tableModel =  new jaxx.runtime.swing.editor.config.model.ConfigTableModel(categoryModel);
        $objectMap.put("tableModel", tableModel);
        tableModel.addTableModelListener((javax.swing.event.TableModelListener) jaxx.runtime.Util.getEventListener(javax.swing.event.TableModelListener.class, "tableChanged", $JPanel0, "doTableChanged__on__tableModel"));
    }

    protected void createTablePane() {
        tablePane = new javax.swing.JScrollPane();
        $objectMap.put("tablePane", tablePane);
        tablePane.setName("tablePane");
    }

}
