package jaxx.runtime.swing.editor;

import jaxx.runtime.swing.editor.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import java.util.Locale;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.LocaleListCellRenderer;
import static org.nuiton.i18n.I18n.n_;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nEditor extends javax.swing.JPanel implements PropertyChangeListener,  ActionListener, jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.I18nEditor.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTU8TQRgeKm1pgQqCJCYaPsREL1s9GD9AUFAUUpTQxhB7cdod2yHDzjgzC4sHY+LVGE4evKh3j96N8ejJq//BGP+B78x2uy1UbKSHfrz7PM8877wf/fgTJZVEk5s4CBzpe5puEWfl1sbGg8omqerbRFUlFZpLFL56EihRRv1uM640OlsuGHq+Qc8v8i3BPeK1sGcKKKv0LiOqTojW6GTIqCqVLzbDM4HwZaTWNNNJ7f3vX4k998WHBEKBAFc5SGHiX6w4g94CSlBXoxNw0jbOM+zVwIakXg18DprYIsNK3cdb5Cl6jtIFlBJYgphGU92najUsPxAapavc01Zius2o2oFjHeJSoDrLl656d+xXISw1pdGIIgwqQdwS56xERYkEIDJkXDrGuRM6jwljHtfFgxzzNBej+lSd74Raw7HWAuAJ9vbBlsG7+T0SxwcEF754SBWtMLLvWZrxKoaaapSzyr6mzClQpWNILkqqYKFRPiHShloswM27RBKp0YUOVxfCjfwiYWy9gTXcTFMiad3C1ZhTggZxZc0EV4nnx2dlLbCAK4RBe7ShbdDAJpvoVMXXGsqKTrUhS7xWY2TBPmv3kabgLjA3M9UhEzN2Ieuu5GAqboHpom2uZY9qihl9RuRFjcatRBU6kDIinQMQ4Es0EoKUcuI5iwehp4yS0relGirHI7kOoXAYG1ErYKPvXr7dfvPp8/Vo8gbgjME2SMuigEkQkguoHDVHHA/HzRQ5v4rFTBllwjawW2S0xUCxEQYToD8c98Y9rOpATaZ/fPk69vj7MZRYQlnGsbuEDX4ZZXRdQpacuYGYv2mdDOz0wfuQ8QQlY3iXwx2j3KyLNZ6oQEXg7ucCSHa0Jdmmg297r1ZPvz5zJUq4JzS0DxYnnXyEUtRj1CN2yTT2R8el0i8U8V0e74lOm6PHfGajZrhs3691yqxtUmcD33zcsIbNt3mrM96tTrQwjqCTqnDphoP4F5WpLlTSxMOwYcyyng2vdQJrWHgweWSus+y5LmR7dSPB4v9rDDzhVV+tYQp73T1E63wXWhmrhRu79AhCvfTwDuhGoy9azkfSMeGNIzrp1+3/X4dI/QGDIcIHyQgAAA==";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JToggleButton button;
    protected jaxx.runtime.swing.editor.I18nEditor content = this;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected jaxx.runtime.swing.JAXXButtonGroup indexes;
    protected java.util.List< Locale > locales;
    protected java.lang.String notSelectedToolTipText;
    protected javax.swing.JPopupMenu popup;
    protected javax.swing.JLabel popupLabel;
    protected java.lang.Boolean popupVisible;
    protected jaxx.runtime.swing.LocaleListCellRenderer renderer;
    protected java.util.Locale selectedLocale;
    protected java.lang.String selectedToolTipText;
    protected java.lang.Boolean showIcon;
    protected java.lang.Boolean showText;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource2 = new jaxx.runtime.DataBindingListener(content, "renderer.showIcon");
    private java.beans.PropertyChangeListener $DataSource3 = new jaxx.runtime.DataBindingListener(content, "renderer.showText");
    private java.beans.PropertyChangeListener $DataSource5 = new jaxx.runtime.DataBindingListener(content, "button.icon");
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener(content, "button.selected");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener(content, "button.text");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener(content, "button.toolTipText");

    /* begin raw body code */
    public static final String DEFAULT_SELECTED_TOOLTIP = n_("i18neditor.selected");
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = n_("i18neditor.unselected");
    public static final String LOCALES_PROPERTY = "locales";
    public static final String SELECTED_LOCALE_PROPERTY = "selectedLocale";
    public static final String SHOW_ICON_PROPERTY = "showIcon";
    public static final String SHOW_TEXT_PROPERTY = "showText";
    public static final String POPUP_VISIBLE_PROPERTY = "popupVisible";
    
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug(name+" <old:"+evt.getOldValue()+" - new:"+evt.getNewValue()+">");
        }
        log.info(name+" <old:"+evt.getOldValue()+" - new:"+evt.getNewValue()+">");
        if (LOCALES_PROPERTY.equals(name)) {
            Locale oldLocale = getSelectedLocale();
            java.util.Collection<?> newLocales = (java.util.Collection<?>) evt.getNewValue();
            // mise a jour de la popup
            boolean oldShowText = renderer.isShowText();
            try {
                renderer.setShowText(true);
                popup.removeAll();
                for (Object o : newLocales) {
                    Locale l = (Locale) o;
                    boolean selected = l.equals(selectedLocale);
                    String text = renderer.getText(l);
                    Icon icon = renderer.getIcon(l);
                    JRadioButtonMenuItem b = new JRadioButtonMenuItem(text, icon, selected);
                    popup.add(b);
                    b.addActionListener(this);
                    b.putClientProperty("locale", l);
                    b.setToolTipText(getTip(l));
                    b.putClientProperty(JAXXButtonGroup.BUTTON8GROUP_CLIENT_PROPERTY, getIndexes());
                    b.putClientProperty(JAXXButtonGroup.VALUE_CLIENT_PROPERTY, l);
                }
            } finally {
                renderer.setShowText(oldShowText);
                popup.invalidate();
            }
            return;
        }
        if (SHOW_ICON_PROPERTY.equals(name)) {
            renderer.setShowIcon((Boolean) evt.getNewValue());
            processDataBinding("button.icon");
            return;
        }
        if (SHOW_TEXT_PROPERTY.equals(name)) {
            renderer.setShowText((Boolean) evt.getNewValue());
            processDataBinding("button.text");
            return;
        }
        if (POPUP_VISIBLE_PROPERTY.equals(name)) {
            Boolean newValue = (Boolean) evt.getNewValue();
            if (newValue == null || !newValue) {
                if (getPopup() != null && getPopup().isVisible()) {
                    getPopup().setVisible(false);
                }
                return;
            }
            if (!getPopup().isVisible()) {
                SwingUtilities.invokeLater(showPopupRunnable);
            }
            return;
        }
        if (SELECTED_LOCALE_PROPERTY.equals(name)) {
            Locale newLocale = (Locale) evt.getNewValue();
            // mise a jour de la popup
            try {
                for (Component c : popup.getComponents()) {
                    if (c instanceof JRadioButtonMenuItem) {
                        JRadioButtonMenuItem b = (JRadioButtonMenuItem) c;
                        Locale l = (Locale) b.getClientProperty("locale");
                        b.setSelected(newLocale.equals(l));
                    }
                }
            } finally {
                popup.invalidate();
            }
            return;
        }
    }
    
    @Override
    public void actionPerformed(ActionEvent event) {
        Locale value = (Locale) ((JComponent)event.getSource()).getClientProperty("locale");
        if (log.isDebugEnabled()) {
            log.debug("new locale : " + value);
        }
        setSelectedLocale(value);
    }
    
    public void loadI18nBundles() {
        Locale[] locales = org.nuiton.i18n.I18n.getLoader().getLocales();
        setLocales(java.util.Arrays.asList(org.nuiton.i18n.I18n.getLoader().getLocales()));
    }
    
    protected String getTip(Locale l) {
        boolean selected = l.equals(selectedLocale);    
        String tip = selected ? getSelectedTip(l):getNotSelectedTip(l);
        return tip;
    }
    
    protected String getSelectedTip(Locale l) {
        String selectedTip = getSelectedToolTipText();
        if (selectedTip == null) {
            // use default selected tip text
            selectedTip = DEFAULT_SELECTED_TOOLTIP;
        }
        String tip = renderer.getToolTipText(l);
        tip = _(selectedTip, tip);
        return tip;
    }
    
    protected String getNotSelectedTip(Locale l) {
        String selectedTip = getNotSelectedToolTipText();
        if (selectedTip == null) {
            // use default not selected tip text
            selectedTip = DEFAULT_NOT_SELECTED_TOOLTIP;
        }
        String tip = renderer.getToolTipText(l);
        tip = _(selectedTip, tip);
        return tip;
    }protected Runnable showPopupRunnable;
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public I18nEditor() {
        $initialize();
    }

    public I18nEditor(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("renderer.showIcon".equals($binding)) {
                addPropertyChangeListener("showIcon", $DataSource2);
        
        } else if ("renderer.showText".equals($binding)) {
                addPropertyChangeListener("showText", $DataSource3);
        
        } else if ("button.icon".equals($binding)) {
                addPropertyChangeListener("selectedLocale", $DataSource5);
        
        } else if ("button.selected".equals($binding)) {
            if (popup != null) {
                $bindingSources.put("popup", popup);
        popup.addComponentListener((java.awt.event.ComponentListener) jaxx.runtime.Util.getEventListener(java.awt.event.ComponentListener.class, content, "$pr$u0"));
            }
        } else if ("button.text".equals($binding)) {
                addPropertyChangeListener("selectedLocale", $DataSource7);
        
        } else if ("button.toolTipText".equals($binding)) {
                addPropertyChangeListener("selectedLocale", $DataSource8);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("renderer.showIcon".equals($dest)) {
            renderer.setShowIcon((isShowIcon()));
            } else if ("renderer.showText".equals($dest)) {
            renderer.setShowText((isShowText()));
            } else if ("button.icon".equals($dest)) {
            button.setIcon((renderer.getIcon(getSelectedLocale())));
            } else if ("button.selected".equals($dest)) {
            if (popup != null) {
                button.setSelected((popup.isVisible()));
            }
            } else if ("button.text".equals($dest)) {
            button.setText(_(String.valueOf((SwingUtil.getStringValue(renderer.getText(getSelectedLocale()))))));
            } else if ("button.toolTipText".equals($dest)) {
            button.setToolTipText(_(String.valueOf((getTip(getSelectedLocale())))));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("renderer.showIcon".equals($binding)) {
                removePropertyChangeListener("showIcon", $DataSource2);
        
        } else if ("renderer.showText".equals($binding)) {
                removePropertyChangeListener("showText", $DataSource3);
        
        } else if ("button.icon".equals($binding)) {
                removePropertyChangeListener("selectedLocale", $DataSource5);
        
        } else if ("button.selected".equals($binding)) {
            if (popup != null) {
                ((javax.swing.JPopupMenu) $bindingSources.remove("popup")).removeComponentListener((java.awt.event.ComponentListener) jaxx.runtime.Util.getEventListener(java.awt.event.ComponentListener.class, content, "$pr$u0"));
            }
        } else if ("button.text".equals($binding)) {
                removePropertyChangeListener("selectedLocale", $DataSource7);
        
        } else if ("button.toolTipText".equals($binding)) {
                removePropertyChangeListener("selectedLocale", $DataSource8);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doFocusGained__on__content(java.awt.event.FocusEvent event) {
        button.requestFocus();
    }

    public void doFocusLost__on__content(java.awt.event.FocusEvent event) {
        setPopupVisible(false);
    }

    public void doItemStateChanged__on__button(java.awt.event.ItemEvent event) {
        if (event.getStateChange()  == ItemEvent.SELECTED) { setPopupVisible(true); } else { popupVisible = false; };
    }

    public void doPopupMenuCanceled__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    public void doStateChanged__on__indexes(javax.swing.event.ChangeEvent event) {
        log.info(indexes.getSelectedValue());
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JToggleButton getButton() {
        return button;
    }

    public jaxx.runtime.swing.editor.I18nEditor getContent() {
        return content;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public java.util.List< Locale > getLocales() {
        return locales;
    }

    public java.lang.String getNotSelectedToolTipText() {
        return notSelectedToolTipText;
    }

    public javax.swing.JPopupMenu getPopup() {
        return popup;
    }

    public javax.swing.JLabel getPopupLabel() {
        return popupLabel;
    }

    public java.lang.Boolean getPopupVisible() {
        return popupVisible;
    }

    public jaxx.runtime.swing.LocaleListCellRenderer getRenderer() {
        return renderer;
    }

    public java.util.Locale getSelectedLocale() {
        return selectedLocale;
    }

    public java.lang.String getSelectedToolTipText() {
        return selectedToolTipText;
    }

    public java.lang.Boolean getShowIcon() {
        return showIcon;
    }

    public java.lang.Boolean getShowText() {
        return showText;
    }

    public java.lang.Boolean isPopupVisible() {
        return popupVisible !=null && popupVisible;
    }

    public java.lang.Boolean isShowIcon() {
        return showIcon !=null && showIcon;
    }

    public java.lang.Boolean isShowText() {
        return showText !=null && showText;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setLocales(java.util.List< Locale > newValue) {
        java.util.List< Locale > oldValue = this.locales;
        this.locales = newValue;
        firePropertyChange("locales", oldValue, newValue);
    }

    public void setNotSelectedToolTipText(java.lang.String newValue) {
        java.lang.String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = newValue;
        firePropertyChange("notSelectedToolTipText", oldValue, newValue);
    }

    public void setPopupVisible(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.popupVisible;
        this.popupVisible = newValue;
        firePropertyChange("popupVisible", oldValue, newValue);
    }

    public void setRenderer(jaxx.runtime.swing.LocaleListCellRenderer newValue) {
        jaxx.runtime.swing.LocaleListCellRenderer oldValue = this.renderer;
        this.renderer = newValue;
        firePropertyChange("renderer", oldValue, newValue);
    }

    public void setSelectedLocale(java.util.Locale newValue) {
        java.util.Locale oldValue = this.selectedLocale;
        this.selectedLocale = newValue;
        firePropertyChange("selectedLocale", oldValue, newValue);
    }

    public void setSelectedToolTipText(java.lang.String newValue) {
        java.lang.String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = newValue;
        firePropertyChange("selectedToolTipText", oldValue, newValue);
    }

    public void setShowIcon(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showIcon;
        this.showIcon = newValue;
        firePropertyChange("showIcon", oldValue, newValue);
    }

    public void setShowText(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showText;
        this.showText = newValue;
        firePropertyChange("showText", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void $pr$u0(java.awt.event.ComponentEvent event) {
        $DataSource6.propertyChange(null);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToContent();
        addChildrenToPopup();
        
        applyDataBinding("renderer.showIcon");
        applyDataBinding("renderer.showText");
        popup.setBorder((new TitledBorder(_("i18neditor.popup.title"))));
        applyDataBinding("button.icon");
        applyDataBinding("button.selected");
        applyDataBinding("button.text");
        applyDataBinding("button.toolTipText");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("content", this);
        createSelectedToolTipText();
        createNotSelectedToolTipText();
        createShowText();
        createShowIcon();
        createPopupVisible();
        createLocales();
        createSelectedLocale();
        createRenderer();
        createPopup();
        createPopupLabel();
        createButton();
        createIndexes();
        create$ScriptInitializer0();
        content.setName("content");
        content.setLayout((new BorderLayout()));
        content.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusGained", content, "doFocusGained__on__content"));
        content.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", content, "doFocusLost__on__content"));
        
        
        addPropertyChangeListener(this);
        $completeSetup();
    }

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add(renderer);
        content.add(button, BorderLayout.CENTER);
    }

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupLabel);
    }

    protected void create$ScriptInitializer0() {
        showPopupRunnable = new Runnable() {
            @Override
            public void run() {
                getPopup().pack();
                Dimension dim = getPopup().getPreferredSize();
                JToggleButton invoker = getButton();
                getPopup().show(invoker, (int) (invoker.getPreferredSize().getWidth() - dim.getWidth()), invoker.getHeight());
        //        getPopup().setVisible(true);
            }
        };
    }

    protected void createButton() {
        button = new javax.swing.JToggleButton();
        $objectMap.put("button", button);
        button.setName("button");
        button.setFocusPainted(false);
        button.setFocusable(true);
        button.addItemListener((java.awt.event.ItemListener) jaxx.runtime.Util.getEventListener(java.awt.event.ItemListener.class, "itemStateChanged", content, "doItemStateChanged__on__button"));
    }

    protected void createIndexes() {
        indexes = new jaxx.runtime.swing.JAXXButtonGroup();
        $objectMap.put("indexes", indexes);
        indexes.addChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, "stateChanged", content, "doStateChanged__on__indexes"));
    }

    protected void createLocales() {
        locales = null;
        $objectMap.put("locales", locales);
    }

    protected void createNotSelectedToolTipText() {
        notSelectedToolTipText = null;
        $objectMap.put("notSelectedToolTipText", notSelectedToolTipText);
    }

    protected void createPopup() {
        popup = new javax.swing.JPopupMenu();
        $objectMap.put("popup", popup);
        popup.setName("popup");
        popup.addPopupMenuListener((javax.swing.event.PopupMenuListener) jaxx.runtime.Util.getEventListener(javax.swing.event.PopupMenuListener.class, "popupMenuCanceled", content, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener((javax.swing.event.PopupMenuListener) jaxx.runtime.Util.getEventListener(javax.swing.event.PopupMenuListener.class, "popupMenuWillBecomeInvisible", content, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        popupLabel = new javax.swing.JLabel();
        $objectMap.put("popupLabel", popupLabel);
        popupLabel.setName("popupLabel");
        popupLabel.setEnabled(false);
        popupLabel.setText(_("i18neditor.empty.locales"));
    }

    protected void createPopupVisible() {
        popupVisible = Boolean.FALSE;
        $objectMap.put("popupVisible", popupVisible);
    }

    protected void createRenderer() {
        renderer = new LocaleListCellRenderer(showIcon , showText);
        $objectMap.put("renderer", renderer);
        renderer.setName("renderer");
    }

    protected void createSelectedLocale() {
        selectedLocale = Locale.getDefault();
        $objectMap.put("selectedLocale", selectedLocale);
    }

    protected void createSelectedToolTipText() {
        selectedToolTipText = null;
        $objectMap.put("selectedToolTipText", selectedToolTipText);
    }

    protected void createShowIcon() {
        showIcon = Boolean.TRUE;
        $objectMap.put("showIcon", showIcon);
    }

    protected void createShowText() {
        showText = Boolean.TRUE;
        $objectMap.put("showText", showText);
    }

}
