/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.jaxx.plugin.AbstractJaxxMojo;

public abstract class AbstractGenerateHelpMojo
extends AbstractJaxxMojo {
    @Parameter(property="jaxx.locales", required=true)
    protected String locales;
    @Parameter(property="jaxx.outputHelpIds", defaultValue="target/generated-sources/jaxx", required=true)
    private File outputHelpIds;
    @Parameter(property="jaxx.helpIdsFilename", defaultValue="helpIds.properties", required=true)
    private String helpIdsFilename;
    @Parameter(property="jaxx.mergeHelpIdsFilename", defaultValue="helpIds-all.properties", required=true)
    private String mergeHelpIdsFilename;
    @Parameter(property="jaxx.generateSearch", defaultValue="true", required=true)
    protected boolean generateSearch;
    private Locale defaultLocale;
    private Locale[] localesToTreate;

    protected abstract void doActionForLocale(Locale var1, boolean var2, File var3, String var4) throws Exception;

    protected abstract void postDoAction();

    protected void init() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.locales)) {
            throw new MojoFailureException("You must set the 'locales' property properly (was " + this.locales + ").");
        }
        if (this.getTargetDirectory() == null) {
            throw new MojoFailureException("You must set the 'outputHelpXXX' property.");
        }
        ArrayList<Locale> tmp = new ArrayList<Locale>();
        for (String loc : this.locales.split(",")) {
            Locale l = I18nUtil.newLocale((String)loc);
            tmp.add(l);
        }
        if (tmp.isEmpty()) {
            throw new MojoFailureException("No locale to react, you must set the 'locales' property.");
        }
        this.localesToTreate = tmp.toArray(new Locale[tmp.size()]);
        this.defaultLocale = this.localesToTreate[0];
        this.createDirectoryIfNecessary(this.getTargetDirectory());
    }

    protected boolean checkSkip() {
        if (!this.generateHelp) {
            this.getLog().info((CharSequence)"generateHelp flag is off, will skip goal.");
            return false;
        }
        return true;
    }

    protected void doAction() throws Exception {
        for (Locale locale : this.localesToTreate) {
            boolean isDefaultLocale = this.defaultLocale.equals(locale);
            String language = locale.getLanguage();
            String localePath = isDefaultLocale ? "default" : language;
            File source = new File(this.getTargetDirectory(), localePath);
            this.createDirectoryIfNecessary(source);
            this.doActionForLocale(locale, isDefaultLocale, source, localePath);
        }
        this.postDoAction();
    }

    public File getOutputHelpIds() {
        return this.outputHelpIds;
    }

    public void setOutputHelpIds(File outputHelpIds) {
        this.outputHelpIds = outputHelpIds;
    }

    public File getHelpIdsStoreFile() {
        return this.outputHelpIds == null ? null : new File(this.outputHelpIds, this.helpIdsFilename);
    }

    public File getMergeHelpIdsStoreFile() {
        return this.outputHelpIds == null ? null : new File(this.outputHelpIds, this.mergeHelpIdsFilename);
    }

    public String getHelpIdsFilename() {
        return this.helpIdsFilename;
    }

    public void setHelpIdsFilename(String helpIdsFilename) {
        this.helpIdsFilename = helpIdsFilename;
    }

    public String getMergeHelpIdsFilename() {
        return this.mergeHelpIdsFilename;
    }

    public void setMergeHelpIdsFilename(String mergeHelpIdsFilename) {
        this.mergeHelpIdsFilename = mergeHelpIdsFilename;
    }

    protected void cleanHelpIdsStore() throws IOException {
        File idsStore = this.getHelpIdsStoreFile();
        if (idsStore.exists()) {
            boolean b;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("delete id store " + idsStore));
            }
            if (!(b = idsStore.delete())) {
                throw new IOException("could not delete file " + idsStore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> loadHelpIds(File file) throws IOException {
        BufferedReader reader = null;
        HashSet<String> result = new HashSet<String>();
        reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.getEncoding()));
        try {
            String id;
            while ((id = reader.readLine()) != null) {
                result.add(id.trim());
            }
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("load " + result.size() + " help ids from file " + file));
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
        finally {
            reader.close();
        }
    }

    protected void storeHelpIds(File file, Set<String> ids) throws IOException {
        this.createDirectoryIfNecessary(file.getParentFile());
        StringBuilder buffer = new StringBuilder();
        for (String helpId : ids) {
            buffer.append(this.removeQuote(helpId)).append('\n');
        }
        this.writeFile(file, buffer.toString(), this.getEncoding());
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("stored " + ids.size() + " help ids in " + file));
        }
    }

    protected String removeQuote(String txt) {
        if (txt.startsWith("\"")) {
            txt = txt.substring(1);
        }
        if (txt.endsWith("\"")) {
            txt = txt.substring(0, txt.length() - 1);
        }
        return txt;
    }
}

