package org.nuiton.jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.runtime.swing.editor.bean.BeanComboBox;

public class BeanComboBoxDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUu24TQRS9NrHzcMiLR4FAipSQIEh2Q0NjxCOxIogMQUmKCDeMdwd7w3pmmJnFmyYFBR0/QEFLg/IPERUSDW3+ASmfwJ3ZjR0H24HgYta6c++Zc8/MuV9/QU5JWOCy5rAo0Jw5OySOHRkxHTSos/Z4e3u9ukM9XaLKk4HQXELyy2QhW4GC34orDU6ljEhuguQaJDdFcld4Q3BG2QmgYhlGlN4NqapTqjXc6lnsKeVutjKLsYhkelZX1t3O+vHh7mGGlj5lAWKB9Iex7Tv/ANDueqAM2cDXMFXeIe+IGxJWQ3IyYDVs6KKJrYREqeekQd/CHgyWIS+IRDANi+eSx8JZqFhoKMyWaIO/IIyGSxqKp1vwcdPxjtGSGPVxXzrLlDA8p8qXeWwwhLCoeQ2Ds1ukGlLEm+kliWpig45NM0XDrdopj7PXQS2SRAecWV4YNDLEadGaDZr00XYViTQ3TYdU0+VI43karnRUrdSp9wapmorxVuG4qvPmBlVUJ1UmfLkz5ZJJKVGPIyUue6YNeakWGu717zrVr4r6dYjY2VJBUhWFutXsZOf2mKIh+oj6GzbttEZlUk3Krgt8mXO9CKETnLYT2o8yU4GcjDCMV9jbhMZHG5iVOGimt4PMMTbx/f6e/NI8Ojy2zQCSmz6r6sSEwDcsJBdU6sBwG088E+kgdJ8RUaygD60sdnzM92e+mWYie2QxaZAcg+Q8IaqOaLnBw4NvV1/9vADZVRgJOfFXicl/CsO6jpdT56Efi4ePLLnR5hCuE4amhnxIdjm+Exi77xNNpqsB8/FWHsSo0nx/lVqk9tePvn/+ePPgWKkMcpz9m8q2WrmXkA9YGDBqR0w6PbqOlIJQNPJ5ezR0GxYZ8x0Rqc/n7Hr7z/5NeMEsi3FkPo5lb/4t2b2JMxHQTMYcW7uC9sG59t9MbiDCb9aXBb6zBgAA";
    private static final Log log = LogFactory.getLog(BeanComboBoxDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox autoCompleteButton;
    protected BeanComboBox<People> comboBox;
    protected JPanel configurationPanel;
    protected BeanComboBoxDemoHandler handler;
    protected JPanel resultPanel;
    protected JLabel selectedResult;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanComboBoxDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanComboBoxDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanComboBoxDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanComboBoxDemo() {
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanComboBoxDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanComboBoxDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAutoCompleteButton() {
        return autoCompleteButton;
    }

    public BeanComboBox<People> getComboBox() {
        return comboBox;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public BeanComboBoxDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPanel() {
        return resultPanel;
    }

    public JLabel getSelectedResult() {
        return selectedResult;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        configurationPanel.add(autoCompleteButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
    }

    protected void addChildrenToResultPanel() {
        resultPanel.add(selectedResult, BorderLayout.CENTER);
    }

    protected void createAutoCompleteButton() {
        $objectMap.put("autoCompleteButton", autoCompleteButton = new JCheckBox());
        
        autoCompleteButton.setName("autoCompleteButton");
    }

    protected void createComboBox() {
        $objectMap.put("comboBox", comboBox = new BeanComboBox<People>());
        
        comboBox.setName("comboBox");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createResultPanel() {
        $objectMap.put("resultPanel", resultPanel = new JPanel());
        
        resultPanel.setName("resultPanel");
        resultPanel.setLayout(new BorderLayout());
    }

    protected void createSelectedResult() {
        $objectMap.put("selectedResult", selectedResult = new JLabel());
        
        selectedResult.setName("selectedResult");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new BeanComboBoxDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createAutoCompleteButton();
        createShowResetButton();
        createShowDecoratorButton();
        createComboBox();
        createResultPanel();
        createSelectedResult();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(comboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfigurationPanel();
        addChildrenToResultPanel();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 4 property setters
        comboBox.setBeanType(People.class);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}