package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.SimpleTimeEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SimpleTimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_DATE = "editor.date";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Ty27TQBS9MXk0CVCgDxW1SCVUKEWVUx4b1AoKLQWiFBDpoiILGMdD4sqxB3tMXVVFfAKfAHs2SOxYIRasWbBB/AJCLNgi7owdJ6ZuGxEpTnQf5557fO7bH5BxHTi7SXxfdTyLGx2qVm9sbNzXNmmTr1C36RiM2w4En5QCSgOKehR3OZxr1ER7JWyvLNsdZlvU6uteqEHB5dsmdduUcg5n4h1N163Uo/SCzzynixqRSkJ9/eun8kp/+UYB8Bmyy+Eq04d19TZJ10AxdA6ncNJzUjGJ1UIajmG1kO8xEVs2ieveIx36DF5ArgZZRhwE41AafGWJIft9xqE4s0I79gNiUXOewxVJVseI2uxCqDJGdQNB1LrRYSZdxxm3ZEA0MybhshzyonPN1qnJ4er/QMneHl5uZp1oJkViEzEV3S3URJU5UZmPGopN23pqtOQ6qKOQzA+rqzIo6oaj8mxAhcOFBPh9aMYRCg51PZMLbBEZjWeHZqo1okll41xkVBRNMLTIZGw6mk/tma/njlQDMo6HYVSjsdevDzEVOHXiH6cKQJn9Mz7y9cP396tde2Zx9lhiad91oW2YYzPqcEOMHg686XHDrKwRttCAvEtNPE15elMJxOphGsnhvJOiXRXt6h3ithEik/v28dP4ky9HQFmFgmkTfZWI+ruQ522Ut22bus+uL0lGR7eG8HkCvwq+PpNs2x66f2zHolvTtx1Dr8lIeX7u4uwuFmi2oyNzWJQF6wY3qX5TxsqPyyVBVRrU8joadcIXHljIcwg3bKs0O7vro6ZTCZpGi2n5z79H6u+WurqmcM/T+5b3tM08gqxhmYZF5eGHN5146EXmUk+3e7ebdM0QPwAWHlJJPs/vUTDNIa1RYmHXTnS4qNpQ+L63MS/Y449OOBUyR2Vqi3JxE+WYzJcPllmAhSIHP4G6gt2clE38UyG6y8MW6LfAqBwdDA1NEKN2aWBqHbHffsz67v0wdqk+dscXUUEyrRmWjvd/bQ9ySjwLgyAG+4h8NRllfACUNKc+PwBjEjH+AmUTjwyKBwAA";
    private static final Log log = LogFactory.getLog(SimpleTimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configPanel;
    protected SimpleTimeEditorDemoModel demoModel;
    protected SimpleTimeEditor editor;
    protected final SimpleTimeEditorDemoHandler handler = new SimpleTimeEditorDemoHandler();
    protected JPanel resultPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SimpleTimeEditorDemo $DemoPanel0 = this;
    private JLabel $JLabel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SimpleTimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SimpleTimeEditorDemo() {
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimpleTimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigPanel() {
        return configPanel;
    }

    public SimpleTimeEditorDemoModel getDemoModel() {
        return demoModel;
    }

    public SimpleTimeEditor getEditor() {
        return editor;
    }

    public SimpleTimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPane() {
        return resultPane;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToResultPane() {
        if (!allComponentsCreated) {
            return;
        }
        resultPane.add($JLabel0, BorderLayout.CENTER);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new JPanel());
        
        configPanel.setName("configPanel");
        configPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDemoModel() {
        $objectMap.put("demoModel", demoModel = new SimpleTimeEditorDemoModel());
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new SimpleTimeEditor(this));
        
        editor.setName("editor");
        editor.setProperty("time");
    }

    protected void createResultPane() {
        $objectMap.put("resultPane", resultPane = new JPanel());
        
        resultPane.setName("resultPane");
        resultPane.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToResultPane();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        editor.setBorder(new TitledBorder(_("jaxxdemo.timeeditor.editor")));
        configPanel.setBorder(new TitledBorder(_("jaxxdemo.numbereditor.configuration")));
        editor.setBean(demoModel);
        resultPane.setBorder(new TitledBorder(_("jaxxdemo.timeeditor.model")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createDemoModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigPanel();
        createEditor();
        createResultPane();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    $JLabel0.setText(_("jaxxdemo.timeeditor.value", demoModel.getTime()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("time", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    editor.setDate(demoModel.getTime());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("time", this);
                }
            }
        });
    }

}