package jaxx.demo.feature.nav;

/*
 * #%L
 * JAXX :: Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.DemoDataProvider;
import jaxx.demo.feature.nav.tree.NavDemoTreeHelper;
import jaxx.demo.feature.nav.treetable.NavDemoTreeTableHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import static org.nuiton.i18n.I18n._;

public class NavDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz08bRxQe3NrEEAKBlB8JJZAQpaqSdemhUgRJSE0RQYYgjBIU59Dx7oCHjHemM7Nm4RDlT8if0N5zqdRbT1UPPffQS9V/oap66LXKm931rjcsYMnhYNC8933ve2/efObt3yivJJo7wL5vSc/VtEms9Ue7u0/qB8TWK0TZkgrNJQp/+nIoV0ODTnyuNLpZqxh4KYKXyrwpuEvcDvRiBQ0ofcSIahCiNfo0jbCVKlXj8KIvPNlmjUVlsX7/7z+5N87rH3II+QLUDUMrs+ehkk4+rqAcdTQahUotXGLY3QcZkrr7oHfInJUZVmoTN8l36BXqr6CCwBLINLrRfcsBR4D3hUaD8yukybewS9gXMIdArAMn1h7B2pPEcnHL2sQtkyVEgCtoNGRzVwN9BR9xD8rPpJpUhyDZKmPphPEvE+BFB2u8JXmLOkTCVSX1gI1qSpRlKq10ZCXgAS0JWSNMGOidbKkmpa13J05POIZNwg6us5joq9OJtMnrZOsAJpT9Dew6zFDNnzm+tTAtARaVYFSb2Ws0bq7Xj0a3Xm0HTGYxGfv8OiioE8eE4LomUqAkZNKvdaKqtuSMZaKSkEmfiVGXQDndx5py13Su0eV0MTgzmXPZZRbM4c0041iaMZilRte53LcO4AG/1FyE7L61vhtnGPDtZNbR4sEjSckJFjjddnEe8I/dPQ4tX83YzygqTgIC8QsQkOhaCgi+YCW+kDzcvhrKSw+ONZqsnbSSbQiFJjL5nokYwiD6//jYHz//9dNq2zlGofYnmakdxgcvWkhulpia0sOhbXiastIGFos1WDDCwDUDV5zOEFaNwiAO6gUXbBm4tYZVAyjy/X/+8uv4t79/hHKraIBx7Kxik/8YFXVDwhQ4c3zxcDlQdPHwAnyOGG0aFVjkDJeWzIufrVPXgaE/8GEI0xlDiJXUi7/9N1b9cbk9iD4QNnVqejKM/HNUoC6jLglMNPLHTNMcFIp4Dk98MMsZ+8zvARFtx73g835Wp6Pgszvcsxvf+AIeeLjUo0uhllmswb/rnibQuaF4FLRk/ioHFaa7qFCocwk+aOLL2Sw3umCZanBJj+H1YBY+06+x3OKM2kc9Ek+0zALaH5q2uAda7yp6HFzbWjbRrS6I8k3uhN5wippuSAYl5/opVTRypB70jMCzOVTbwBd+Iaie+MzxxhnNfdYVw3bPDM96YtDois2Z13TLcOmwRedP+vOuVL3omWGvZ4aXPTGAg8b/sWycs8jd6Xl4BsNdYHgHevSux4MLAAA=";
    private static final Log log = LogFactory.getLog(NavDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel content;
    protected CardLayout2 contentLayout;
    protected DemoDataProvider dataProvider;
    protected NavDemoHandler handler;
    protected JTree navigationTree;
    protected JXTreeTable navigationTreeTable;
    protected JSplitPane splitPane;
    protected NavDemoTreeHelper treeHelper;
    protected NavDemoTreeTableHelper treeTableHelper;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NavDemo $DemoPanel0 = this;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JTabbedPane $JTabbedPane0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return new String[]{ getDefaultSource(),
                "NavDemoHandler.java",
                "tree/NavDemoTreeNode.java",
                "tree/NavDemoTreeHelper.java",
                "tree/NavDemoTreeCellRenderer.java",
                "tree/ActorsTreeNodeLoador.java",
                "tree/MoviesTreeNodeLoador.java",
                "treetable/NavDemoTreeTableNode.java",
                "treetable/NavDemoTreeTableHelper.java",
                "treetable/ActorsTreeTableNodeLoador.java",
                "treetable/MoviesTreeTableNodeLoador.java"
         };
    }
    
    private void $afterCompleteSetup() {
        getHandler().$afterCompleteSetup();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NavDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NavDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NavDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NavDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public NavDemo() {
        $initialize();
    }

    public NavDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public NavDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public NavDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getContent() {
        return content;
    }

    public CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public DemoDataProvider getDataProvider() {
        return dataProvider;
    }

    public NavDemoHandler getHandler() {
        return handler;
    }

    public JTree getNavigationTree() {
        return navigationTree;
    }

    public JXTreeTable getNavigationTreeTable() {
        return navigationTreeTable;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public NavDemoTreeHelper getTreeHelper() {
        return treeHelper;
    }

    public NavDemoTreeTableHelper getTreeTableHelper() {
        return treeTableHelper;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JTabbedPane get$JTabbedPane0() {
        return $JTabbedPane0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JTabbedPane0, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new CardLayout2());
    }

    protected void createDataProvider() {
        $objectMap.put("dataProvider", dataProvider = new DemoDataProvider());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new NavDemoHandler(this));
    }

    protected void createNavigationTree() {
        $objectMap.put("navigationTree", navigationTree = new JTree());
        
        navigationTree.setName("navigationTree");
        if (navigationTree.getFont() != null) {
            navigationTree.setFont(navigationTree.getFont().deriveFont((float) 11));
        }
        navigationTree.setRootVisible(false);
        navigationTree.setShowsRootHandles(false);
    }

    protected void createNavigationTreeTable() {
        $objectMap.put("navigationTreeTable", navigationTreeTable = new JXTreeTable());
        
        navigationTreeTable.setName("navigationTreeTable");
        navigationTreeTable.setColumnControlVisible(true);
        if (navigationTreeTable.getFont() != null) {
            navigationTreeTable.setFont(navigationTreeTable.getFont().deriveFont((float) 11));
        }
        navigationTreeTable.setRootVisible(false);
        navigationTreeTable.setShowsRootHandles(false);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
    }

    protected void createTreeHelper() {
        $objectMap.put("treeHelper", treeHelper = new NavDemoTreeHelper(getDataProvider()));
    }

    protected void createTreeTableHelper() {
        $objectMap.put("treeTableHelper", treeTableHelper = new NavDemoTreeTableHelper(getDataProvider()));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add(splitPane, BorderLayout.CENTER);
        addChildrenToSplitPane();
        // inline complete setup of $JTabbedPane0
        $JTabbedPane0.add($JScrollPane0);
        $JTabbedPane0.add($JScrollPane1);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 0));
        $JTabbedPane0.setTitleAt(0, _("jaxxdemo.tree.tabtitle"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 1));
        $JTabbedPane0.setTitleAt(1, _("jaxxdemo.treeTable.tabtitle"));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(navigationTree);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(navigationTreeTable);
        
        // apply 10 property setters
        $JScrollPane0.setBorder(null);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTree.setModel(treeHelper.createModel());
        $JScrollPane1.setBorder(null);
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        navigationTreeTable.setTreeTableModel(treeTableHelper.createModel());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createContentLayout();
        createDataProvider();
        createTreeHelper();
        createTreeTableHelper();
        createHandler();
        createSplitPane();
        // inline creation of $JTabbedPane0
        $objectMap.put("$JTabbedPane0", $JTabbedPane0 = new JTabbedPane());
        
        $JTabbedPane0.setName("$JTabbedPane0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNavigationTree();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createNavigationTreeTable();
        createContent();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("jaxxdemo.tree.tabtitle"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("jaxxdemo.treeTable.tabtitle"));
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}