package jaxx.demo.component.swing;

/*
 * #%L
 * JAXX :: Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.css.DataBinding;
import jaxx.runtime.css.Pseudoclasses;
import jaxx.runtime.swing.VBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class JButtonDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uu24TQRS93sQxToA8TEIQiZRAKBBiTTqkBMhLgUTmoURCEW4Y747tidYzw8xsskmB+AQ+AXoaJDoqREFNQYP4BYQoaBF31utHYuchLHm1uo9zzpx7Z9/9hLRWML1NoshVITesRt31xa2tx6Vt6pkVqj3FpBEK6r+UA04RBvxmXBu4WizY9nzSnl8WNSk45W3dcwXo12YvoLpKqTEwebDD0zq/2UzPRTJUDdSmqG6ob37/cl77r946AJFEdfYoUyd1tU7SWwCH+QZGkGmH5APCKyhDMV5BvedsbDkgWj8iNfoCXkKmAH2SKAQzcOX0R44x4v5IGhiYWaE18YRwGtwycC0W62PE9RoQrt5FBe76UmiM4LZayri/zyA/5R4LDIxadVFSulYjFbrmCd5WOPN0SUTIcPGAHfV6m7J12WZ5diahw45cO3QStmWDndWzNnAhThpIlwn39nAClw9Q4mzd1mxb5qeKkFYhhg2MFzvXYQNT9UUYP7QIFjDO/h3Lffv448NqY/oZ5B7tWtq2vDgVqYSkyjBLPVgffWhYkH9I5FwRspoGuPnxZk90EbaZpFEc8g3bdte2uw+IriJEOvP90+ex5197wFmF/kAQf5XY+jXImqpCF0TgR/LeQqzo7O4ZfA7hvwdtLQtubmq2jzY5s7cbgTLxMJBeVIzg4PvLQtGKEiHHxe0tBSGN0KOJLh41hZayX/7kNt8vNHxKoe5LR5a3vEo/gz7GA8ZpfE+SK9D1XgxITUNftFa92/IDrn8m2RzZ3BebnIyf0x2mOPF5rSkWC7eaGRIw75ALPYr6UWgRrsens2832snQyZoINRU7OPbT8KbwFlSFYvvYS4LFgFV4Lb72I/N1Q6aIwe9EKTT0bgdzyj6HZHIXj6EYtnKY10ZgS+/8P2CvodFxGLnTYDDPGnZ+3ieGTJUY9/EzcMQhx07Es+H7xyiyCP8AJ+D8LoMGAAA=";
    private static final Log log = LogFactory.getLog(JButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ImageIcon pencil;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButtonDemo $DemoPanel0 = this;
    private JButton $JButton0;
    private JButton $JButton1;
    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void buttonClicked(JButton button) {
        JOptionPane.showMessageDialog(this, button.getText() + " clicked!",
        "onActionPerformed",
        JOptionPane.INFORMATION_MESSAGE);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JButtonDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JButtonDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JButtonDemo() {
        $initialize();
    }

    public JButtonDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JButtonDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        buttonClicked((JButton) event.getSource());
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        buttonClicked((JButton) event.getSource());
    }

    public void doMouseEntered__on__$JButton1(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(JButtonDemo.this, $JButton1, "font-style", "italic", Pseudoclasses.wrap(($JButton1.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton1.getFont() != null) {
            if (((String) value).equals("italic")) {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() | Font.ITALIC));
            } else {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
        value = Pseudoclasses.applyProperty(JButtonDemo.this, $JButton1, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap($JButton1.getForeground()), 0);
        if (!(value instanceof DataBinding)) {
            $JButton1.setForeground((Color) value);
        }
    }

    public void doMouseExited__on__$JButton1(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(JButtonDemo.this, $JButton1, "font-style", "italic", Pseudoclasses.wrap(($JButton1.getFont().getStyle() & Font.ITALIC) != 0 ? "italic" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton1.getFont() != null) {
            if (((String) value).equals("italic")) {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() | Font.ITALIC));
            } else {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() & ~Font.ITALIC));
            }
        }
        }
        value = Pseudoclasses.removeProperty(JButtonDemo.this, $JButton1, "foreground", new Color(255, 0, 0), Pseudoclasses.wrap($JButton1.getForeground()), 0);
        if (!(value instanceof DataBinding)) {
            $JButton1.setForeground((Color) value);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ImageIcon getPencil() {
        return pencil;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void create$JButton1() {
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("Fancy Button"));
        if ($JButton1.getFont() != null) {
            $JButton1.setFont($JButton1.getFont().deriveFont((float) 18));
        }
        if ($JButton1.getFont() != null) {
            $JButton1.setFont(new Font("Arial", $JButton1.getFont().getStyle(), $JButton1.getFont().getSize()));
        }
        $JButton1.setForeground(new Color(0, 0, 255));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        $JButton1.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton1"));
        $JButton1.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton1"));
    }

    protected void createPencil() {
        $objectMap.put("pencil", pencil = new ImageIcon(getClass().getResource("/jaxx/demo/images/pencil_black.gif")));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($VBox0);
        // inline complete setup of $VBox0
        $VBox0.add($JButton0);
        $VBox0.add($JButton1);
        
        // apply 1 property setters
        $JButton1.setIcon(pencil);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createPencil();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        $VBox0.setHorizontalAlignment(0);
        $VBox0.setVerticalAlignment(0);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("Simple Button"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        create$JButton1();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        $completeSetup();
    }

}