package jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.EnumEditor;
import jaxx.runtime.swing.editor.LocaleEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.CountryEnum;
import org.nuiton.i18n.LanguageEnum;
import static org.nuiton.i18n.I18n.t;

public class ComboEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JTEXT_AREA0_TEXT = "$JTextArea0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUu24TQRS9NrHjV0IeSpQoQQSwUiCxDogGEoVESSyIzEMkRYQbZr2jZKPx7jA7S9YN4hP4BOhpkOioEAU1BQ3iFxCioEXcmV2vvbB5QFzMru/j3DPX5/j1N8h5Ai7skyAwhO9Iu02NzdWdnfvmPm3Jdeq1hM2lKyD8ZLKQbULZiuOehEvNhmqvRe21NbfNXYc6fd2LDSh5ssOot0eplHAu2dHyvNpWnF4MuC+6qDGpNNSXP75nX1jPX2UBAo7siniVueO6ejcZaEDWtiSM4aSnpMaIs4s0hO3sIt8hFVtjxPPukTZ9As9gsAF5TgSCSbh48itrDN0fcAnl6jptuw+IQ9mChJoma2HEaHUhDB2jlo0gir/pbuh31ce5RspLGKxuE5NRxJhKXNg7QPqGzqnKYtxQqG42iKmnjqmrBVFpGFVFlbi2wtwWYTScK2E+ZULEr9FXmMTozruqvo8mc8Nq1T7ZjSdUD5+w4fjto/CvpeAPtVyEEp1e33SyoFzd3KaBXBWU4D4mEvvoJqIOATMJcqhVo6fVnpgyTcgJH8P4izT/lvdDTIXCnvpD2ApQZ39Njn9+9/VtvavmAs6eSC3tMyOqjAuXUyFtNfpsKGVf2qx2l/DFJnqCMnSydupsCrGtKI3kcN6oajdUu3GbeHsIkRv88v7D5ONPZyBbhxJziVUnqv4OFOWewC24zAr4rRXNqHJQwHNEcZOQZ6Tj+miW4SWLSDJn2o6FG14OcAmzKUuImZjFjz/Ht96sdBeRQWLTh5b3lpF7BHnbYbZDtbEjz6Yaucw96ltuz5tpbs2oZ4lHppvX5+W0mxaYUmI9lNqVwFcPQxNXbwsaZ+QEOAMStYf+XApvMUck/huZvqTL/4upwtePYDV5IoQb6rh5GoSjOMycmsM/IBzC4Twi/AaZXARNDAcAAA==";
    private static final Log log = LogFactory.getLog(ComboEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected EnumEditor<CountryEnum> countryEditor;
    protected EnumEditor<LanguageEnum> languageEditor;
    protected LocaleEditor localeEditor;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ComboEditorDemo $DemoPanel0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JTextArea $JTextArea0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ComboEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ComboEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ComboEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ComboEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ComboEditorDemo() {
        $initialize();
    }

    public ComboEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ComboEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public ComboEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public EnumEditor<CountryEnum> getCountryEditor() {
        return countryEditor;
    }

    public EnumEditor<LanguageEnum> getLanguageEditor() {
        return languageEditor;
    }

    public LocaleEditor getLocaleEditor() {
        return localeEditor;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JTextArea get$JTextArea0() {
        return $JTextArea0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCountryEditor() {
        $objectMap.put("countryEditor", countryEditor = new EnumEditor<CountryEnum>(CountryEnum.class));
        
        countryEditor.setName("countryEditor");
    }

    protected void createLanguageEditor() {
        $objectMap.put("languageEditor", languageEditor = new EnumEditor<LanguageEnum>(LanguageEnum.class));
        
        languageEditor.setName("languageEditor");
    }

    protected void createLocaleEditor() {
        $objectMap.put("localeEditor", localeEditor = new LocaleEditor());
        
        localeEditor.setName("localeEditor");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(localeEditor, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(languageEditor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(countryEditor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JTextArea0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        $JLabel0.setLabelFor(localeEditor);
        $JLabel1.setLabelFor(languageEditor);
        $JLabel2.setLabelFor(countryEditor);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("Locale editor:"));
        createLocaleEditor();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("EnumEditor (language) :"));
        createLanguageEditor();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("EnumEditor (country) :"));
        createCountryEditor();
        // inline creation of $JTextArea0
        $objectMap.put("$JTextArea0", $JTextArea0 = new JTextArea());
        
        $JTextArea0.setName("$JTextArea0");
        $JTextArea0.setColumns(15);
        $JTextArea0.setLineWrap(true);
        $JTextArea0.setWrapStyleWord(true);
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JTEXT_AREA0_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (localeEditor != null) {
                    $bindingSources.put("localeEditor", localeEditor);
                    localeEditor.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
                if (languageEditor != null) {
                    $bindingSources.put("languageEditor", languageEditor);
                    languageEditor.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
                if (countryEditor != null) {
                    $bindingSources.put("countryEditor", countryEditor);
                    countryEditor.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (localeEditor != null && countryEditor != null && languageEditor != null) {
                    SwingUtil.setText($JTextArea0, "locale : "+ localeEditor.getSelectedItem() + "\nlanguage : "+ languageEditor.getSelectedItem() + "\ncountry : " + countryEditor.getSelectedItem());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (localeEditor != null) {
                    LocaleEditor $target = (LocaleEditor) $bindingSources.remove("localeEditor");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
                if (languageEditor != null) {
                    EnumEditor $target = (EnumEditor) $bindingSources.remove("languageEditor");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
                if (countryEditor != null) {
                    EnumEditor $target = (EnumEditor) $bindingSources.remove("countryEditor");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(ItemEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}