package jaxx.demo;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box.Filler;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.FontSizor;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class DemoSources extends JPanel implements JAXXHelpUI<DemoHelpBroker>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CURRENT_SOURCE = "currentSource";
    public static final String PROPERTY_INCOMING_CLASS = "incomingClass";
    public static final String PROPERTY_SOURCES = "sources";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_FONT_SIZE = "editor.font-size";
    public static final String BINDING_FONT_SIZOR_FONT_SIZE = "fontSizor.fontSize";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz2sTQRSeRpM2aavV2tpihForCOJGEBSpqP1hqCVqaYoWc3E2O22nzu5MZ2bN1oP4J/gn6N2L4M2TePDswYv4L4h48Cq+mU2zicYkkByS7L73vvm+t+97++Y7SiuJzuziKHJkGGjqE2d1YXPzvrtLqnqZqKqkQnOJ4s9ACqUqaNhr3Fcana2UTHmhXl5Y4r7gAQmaqudLKKf0PiNqhxCt0enWiqpShXIjPB+JUB6gNki1Q33180fqpffidQqhSAC7YZAy060qUXK4hFLU0+g4nPQUFxgOtoGGpME28B0195YYVuoe9skeeo4GSygjsAQwjWZ7l2wxbH0kNBqaW13DAWGXNJqwTD3ic2cZvso8lFWihLDJGY0yruRPiNRoqjVxhTCxaENJ7igNqtwH5vY0jY4a9o5R5Ng7TZnVUBoN8XEajSWZsfYkdVDFlDQ6YpNCTZlTokonKWPEoyDWSFoh2DNsT5jcyFE1wHJWNzhni1ia9GyjKhcDb2BX2TY05UMnXb7II5M51SgYmYNbc0XKGJHQucnmkiTSWpPd4qCSPuPAKd8yFHFd8SDcWpZLFGl0soVbuSo5YybSKicTl2h0gcttZ4tuESekjlT7gcaRJpGGocHOetleb8D1Alyb2jkBA3uqhRtYwUmskMzqQAWlZcjMw5iq/OuedQjFvpn6yzcG0EZ/T45/ef/tXfHALGNw9kTb1CavwxALyQU8V2qOPho7xQxC4S4W8xWUVYTBorCLIN+GWLkeBnJw3rFkjlaw2gGI9ODXDx8nH38+hFJFlGMce0Vs8u+grN6R0AXOvEjcvGUZjdSGDHHDDbrO8D4PwYtHrntY4xmXBh48phsRNCHfpgkNJm7206/x8ttbB40YAGLT/01PmpF+hDI0YDQgdm/UV0LbPTEsFAk9nli/3TIYML85UTdTwX5fbqd01OUSrLWGaaCJ2VfXYxozWINj3VATEG2qr1o15t81Cz7dA3h2C5quscss9z6AMlzgvbBflLTPPcJM+Ep7kHwPIEN165MOOLNdccztlQ5yuiPA4oIBrhWb2PSBNVblLPSDeM8+oKTWQd25HvDGMUz7AqNYgW1uB2YEvA4Uz/cAORhTVH3CDJmF2mUke8Gxr4CLqvMg9ETI2O2hxKJPQsPwiqZ+6HeZzV6gRmtAx74pHsJ26MLrD8/3qqfnCQAA";
    private static final Log log = LogFactory.getLog(DemoSources.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected DemoHelpBroker broker;
    protected String currentSource;
    protected RSyntaxTextArea editor;
    protected JScrollPane editorPane;
    protected JToolBar editorPaneHeader;
    protected FontSizor fontSizor;
    protected final DemoSourcesHandler handler = createHandler();
    protected Class<?> incomingClass;
    protected JComboBox sourceTabs;
    protected List<String> sources;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Filler $Box$Filler0;
    private DemoSources $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        handler.init(this);    
    }
    
    public DemoConfig getConfig() {
        return getContextValue(DemoConfig.class);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoSources(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemoSources(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoSources(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemoSources(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoSources(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemoSources(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoSources() {
        $initialize();
    }

    public DemoSources(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doItemStateChanged__on__sourceTabs(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if(event.getStateChange() == ItemEvent.SELECTED) { handler.updateSource(event); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoHelpBroker getBroker() {
        return broker;
    }

    public String getCurrentSource() {
        return currentSource;
    }

    public RSyntaxTextArea getEditor() {
        return editor;
    }

    public JScrollPane getEditorPane() {
        return editorPane;
    }

    public JToolBar getEditorPaneHeader() {
        return editorPaneHeader;
    }

    public FontSizor getFontSizor() {
        return fontSizor;
    }

    public DemoSourcesHandler getHandler() {
        return handler;
    }

    public Class<?> getIncomingClass() {
        return incomingClass;
    }

    public JComboBox getSourceTabs() {
        return sourceTabs;
    }

    public List<String> getSources() {
        return sources;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCurrentSource(String currentSource) {
        String oldValue = this.currentSource;
        this.currentSource = currentSource;
        firePropertyChange(PROPERTY_CURRENT_SOURCE, oldValue, currentSource);
    }

    public void setIncomingClass(Class<?> incomingClass) {
        Class<?> oldValue = this.incomingClass;
        this.incomingClass = incomingClass;
        firePropertyChange(PROPERTY_INCOMING_CLASS, oldValue, incomingClass);
    }

    public void setSources(List<String> sources) {
        List<String> oldValue = this.sources;
        this.sources = sources;
        firePropertyChange(PROPERTY_SOURCES, oldValue, sources);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(DemoHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Filler get$Box$Filler0() {
        return $Box$Filler0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorPane() {
        if (!allComponentsCreated) {
            return;
        }
        editorPane.getViewport().add(editor);
    }

    protected void addChildrenToEditorPaneHeader() {
        if (!allComponentsCreated) {
            return;
        }
        editorPaneHeader.add(sourceTabs);
        editorPaneHeader.add($Box$Filler0);
        editorPaneHeader.add(fontSizor);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new DemoHelpBroker("ui.main.sources"));
    }

    protected void createCurrentSource() {
        $objectMap.put("currentSource", currentSource = null);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new RSyntaxTextArea());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(true);
        editor.setAntiAliasingEnabled(true);
        editor.setColumns(80);
        editor.setEditable(false);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(false);
    }

    protected void createEditorPane() {
        $objectMap.put("editorPane", editorPane = new JScrollPane());
        
        editorPane.setName("editorPane");
    }

    protected void createEditorPaneHeader() {
        $objectMap.put("editorPaneHeader", editorPaneHeader = new JToolBar());
        
        editorPaneHeader.setName("editorPaneHeader");
        editorPaneHeader.setBorderPainted(false);
        editorPaneHeader.setFloatable(false);
        editorPaneHeader.setOpaque(false);
    }

    protected void createFontSizor() {
        $objectMap.put("fontSizor", fontSizor = new FontSizor());
        
        fontSizor.setName("fontSizor");
        fontSizor.setOpaque(false);
        fontSizor.setShowFontSize(true);
    }

    protected DemoSourcesHandler createHandler() {
        return new DemoSourcesHandler();
    }

    protected void createIncomingClass() {
        $objectMap.put("incomingClass", incomingClass = null);
    }

    protected void createSourceTabs() {
        $objectMap.put("sourceTabs", sourceTabs = new JComboBox());
        
        sourceTabs.setName("sourceTabs");
        sourceTabs.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__sourceTabs"));
    }

    protected void createSources() {
        $objectMap.put("sources", sources = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(editorPaneHeader, BorderLayout.SOUTH);
        add(editorPane, BorderLayout.CENTER);
        addChildrenToEditorPaneHeader();
        addChildrenToEditorPane();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        sourceTabs.setModel(new DefaultComboBoxModel());
        editorPane.setColumnHeaderView(editorPaneHeader);
        editor.setMinimumSize(SwingUtil.newMinDimension());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$JPanel0", $JPanel0);
        createBroker();
        createIncomingClass();
        createCurrentSource();
        createSources();
        createEditorPaneHeader();
        createSourceTabs();
        // inline creation of $Box$Filler0
        $objectMap.put("$Box$Filler0", $Box$Filler0 = new Filler(SwingUtil.newMinDimension(), SwingUtil.newMinDimension(), SwingUtil.newMaxXDimension()));
        
        $Box$Filler0.setName("$Box$Filler0");
        createFontSizor();
        createEditorPane();
        createEditor();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FONT_SIZOR_FONT_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fontSize", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    fontSizor.setFontSize(getConfig().getFontSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fontSize", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_FONT_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fontSize", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    if (editor.getFont() != null) {
                        editor.setFont(editor.getFont().deriveFont((float) getConfig().getFontSize()));
                    }
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fontSize", this);
                }
            }
        });
    }

}