/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.feature.databinding;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.feature.databinding.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class BeanDataBindingDemo extends jaxx.demo.feature.databinding.BaseBeanDataBinding {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EDITING3 = "editing3";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDIT3_ENABLED = "edit3.enabled";
    public static final String BINDING_EDIT3_TEXT = "edit3.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JBUTTON1_VISIBLE = "$JButton1.visible";
    private static final String BINDING_$JBUTTON2_VISIBLE = "$JButton2.visible";
    private static final String BINDING_$JBUTTON3_VISIBLE = "$JButton3.visible";
    private static final String BINDING_$JBUTTON4_VISIBLE = "$JButton4.visible";
    private static final String BINDING_$JBUTTON5_VISIBLE = "$JButton5.visible";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JTEXT_FIELD0_ENABLED = "$JTextField0.enabled";
    private static final String BINDING_$JTEXT_FIELD1_ENABLED = "$JTextField1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUQU8TURCeVgoUUJQGBEWtUqOJcSsgB1MULKTBpqgRTIi9+Mo+Ycl2d933FtaL8Sf4E/TuxcSbJ+PBswcvxr9gjAevxnlvl21Ll2Xj9tA2M998883szvfuJ2SYDRd3iOsqtmNwrUmV6t2NjQeNHbrJlynbtDWLmzZ4n1Qa0nUYVIM44zBVr4nyol9eXDKblmlQo626VIMBxl/olG1Tyjmc66zYZKy4FqRLruXY+6yBqDDWN79/pV+rr96mAVwL1Z3EUfJHVbUm6alBWlM5jGCnXVLUibGFMmzN2EK9x0VsSSeM3SdN+hxeQl8Nei1iIxmHS/FHlhyy3rU4jBbKhNEyJcYy4aSsGSq2u8FhWspWadNUnlHCHZsqKgIaHkA5ULCMOMuSrL0c+qmqcYzOcjglVCtiEqVsmjpWtWB9hXXS0Ck2G+/YEdsTHWROILMt3kK1RhpUx4oRwev6UC8qQMPt2IfECMHKaCc2W6iWHc5NA8G5DrAXFrDRbvS0CJzpTA4VquvU5RWN6iqyjXWwBZlwqZLv9CHSZoJm+e7kbEiyXYlkvhDedSaq682A+Gp3ci4kmRGPfra9nQ1nO54u3pbSuq3Wy5+qQ8Z2MIyvQ737HB9hyjvE8QOHKAhl9u9Y7tvHHx8q+9eXw96jodA288CrsGzTojbXROth7/QcrunFVWKV6pBlVEfnkc4yGSJszU+jOOznve+iXFkhbBspMn3fP30ee/r1GKQrMKCbRK0Qgb8HWb5t4xZMXXWthUWpaGivX9iG0Mahh+Pz43BiXhxe3r+8Oy6uYDJkBYGORvbLn9za+8X9NaRQ1sSh8NYqMk+gVzN0zaDShnyHCbWdQYtRRzVbThLmLSnxm7P8e5+T37e65xThEh7pvNc7Tzg6XsPhFCcVudtyBPFvQWInjmREZ9nVmObbx/z/0khh4mspnGEyFsNKhIajGXAUaggjVCNoziceJTnDVOJlxGOI0nA5sYZ4DI8jGK4kniI5w7XEe4jHEKXhemIN8RiinkUx/hQRDP8A6MKamJIKAAA=";
    private static final Log log = LogFactory.getLog(jaxx.demo.feature.databinding.BeanDataBindingDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean editing3;
    protected javax.swing.JTextField edit3;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanDataBindingDemo $BaseBeanDataBinding0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JTextField $JTextField0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JButton $JButton2;
    private javax.swing.JButton $JButton3;
    private javax.swing.JTextField $JTextField1;
    private javax.swing.JPanel $JPanel2;
    private javax.swing.JButton $JButton4;
    private javax.swing.JButton $JButton5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return new String[]{ getDefaultSource(), "BaseBeanDataBinding.jaxx" };
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanDataBindingDemo() {
        super();
        $initialize();
    }

    public BeanDataBindingDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        setEditing3(true);
    }

    public void doActionPerformed__on__$JButton5(java.awt.event.ActionEvent event) {
        setEditing3(false);
    }

    public void doKeyReleased__on__edit3(java.awt.event.KeyEvent event) {
        setContentMessage(edit3.getText());
    }

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        setEditing(true);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        setEditing(false);
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        setEditing2(true);
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        setEditing2(false);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getEditing3() {
        return editing3;
    }

    public java.lang.Boolean isEditing3() {
        return editing3 !=null && editing3;
    }

    public javax.swing.JTextField getEdit3() {
        return edit3;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setEditing3(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.editing3;
        this.editing3 = newValue;
        firePropertyChange(PROPERTY_EDITING3, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JTextField get$JTextField0() {
        return $JTextField0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected javax.swing.JTextField get$JTextField1() {
        return $JTextField1;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JButton get$JButton5() {
        return $JButton5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createEditing3() {
        $objectMap.put("editing3", editing3 = true);
    }

    protected void createEdit3() {
        $objectMap.put("edit3", edit3 = new javax.swing.JTextField());
        
        edit3.setName("edit3");
        edit3.setColumns(15);
        edit3.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__edit3"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $BaseBeanDataBinding0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JTextField0, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JTextField1, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(edit3, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($JButton0);
        $JPanel0.add($JButton1);
        // inline complete setup of $JPanel1
        $JPanel1.add($JButton2);
        $JPanel1.add($JButton3);
        // inline complete setup of $JPanel2
        $JPanel2.add($JButton4);
        $JPanel2.add($JButton5);
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$BaseBeanDataBinding0", this);
        createEditing3();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("edit"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("close"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JTextField0
        $objectMap.put("$JTextField0", $JTextField0 = new javax.swing.JTextField());
        
        $JTextField0.setName("$JTextField0");
        $JTextField0.setColumns(15);
        jaxx.runtime.SwingUtil.setText($JTextField0, "to edit");
        
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("edit2"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("close2"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JTextField1
        $objectMap.put("$JTextField1", $JTextField1 = new javax.swing.JTextField());
        
        $JTextField1.setName("$JTextField1");
        $JTextField1.setColumns(15);
        jaxx.runtime.SwingUtil.setText($JTextField1, "to edit 2");
        
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        
        $JPanel2.setName("$JPanel2");
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("edit3"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JButton5
        $objectMap.put("$JButton5", $JButton5 = new javax.swing.JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.setText(_("close3"));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        createEdit3();
        // inline creation of $BaseBeanDataBinding0
        setName("$BaseBeanDataBinding0");
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"contentMessage") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(getContentMessage()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"editing") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isEditing());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_VISIBLE, true ,"editing") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setVisible(isEditing());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTEXT_FIELD0_ENABLED, true ,"editing") {
        
            @Override
            public void processDataBinding() {
                $JTextField0.setEnabled(isEditing());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_VISIBLE, true ,"editing2") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setVisible(!isEditing2());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_VISIBLE, true ,"editing2") {
        
            @Override
            public void processDataBinding() {
                $JButton3.setVisible(isEditing2());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTEXT_FIELD1_ENABLED, true ,"editing2") {
        
            @Override
            public void processDataBinding() {
                $JTextField1.setEnabled(isEditing2());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON4_VISIBLE, true ,"editing3") {
        
            @Override
            public void processDataBinding() {
                $JButton4.setVisible(!isEditing3());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON5_VISIBLE, true ,"editing3") {
        
            @Override
            public void processDataBinding() {
                $JButton5.setVisible(isEditing3());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT3_ENABLED, true ,"editing3") {
        
            @Override
            public void processDataBinding() {
                edit3.setEnabled(isEditing3());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT3_TEXT, true ,"contentMessage") {
        
            @Override
            public void processDataBinding() {
                jaxx.runtime.SwingUtil.setText(edit3, getContentMessage());
            }
        });
    }

}