package jaxx.demo.feature.validation.list;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingListValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.validator.bean.list.BeanListValidator;
import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

public class ListBeanValidationDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW = "$JScrollPane0.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW8bRRgeu3FSOzQpcT9S0oq0uEJ8rdNKIEQqSJMQNZZDq7iNIiwhxt7BnmS8M519N95wQPwEfgLcuSBx44Q4cObABfEXEOLAteKdXe9unGzsFbbkkf1+PPO8z+z7zn7/Fym4mtw+oL5vac8B3mNW7eH+/uPWAWvDJnPbmiuQmoSfXJ7km2TWju0ukNeadZNeHaRXN2RPSYc5J7JX66TkwrFgbpcxAHJrOKPtutVG7F71lacj1JhUGuq3//yd/8b++rs8Ib5CdvNYyvK4rKSSqTrJcxvIAu50RKuCOh2kobnTQb6XjG1DUNf9hPbYc/IVmamTaUU1ggG5k73kACPI9xWQ2com68kn1GFiBcj7AVkbLdYXjIKnmXVEBbcpcOlYgrtg1XFZZ9TZi+0GQKkAchpIoSdtJoDcHw/1hEkl2FPaEmzHJCUgxUGo1EBWpO5YjscB02Kz1UIKIYohY0jtRb4EZp5pLXWyAZC1odNI4Nw+qmw1zDqEtcNcl3ZSOc5UAiuqtjgEGkIFPhNZjBMuVmqRzgvmMP1BaGg1QVfj2Cu4Ow0wGm0thWAmBsj1obzQZTwmazFRL04GsmTUO8D+OASpwkTfqu3H9JbO0Ltn/r8yTGeW2va2jc8Th2Mg5SEW6x7g0ZjA23H8nMZzP2JRirHeHY7Iy8MUa8ThfgqHS5UTBa8Y4y2zvBkHlJLTPq1wXO7bCltyaei8sNmtpNmTbsw1SUF7aMYDbp6dD7voCifD4qnJYAAD74tr5d9/+vPHrWgcXMe9r6aGnphm2KZKS8U0cLP1fDgLPOCiukPVapMUXSZwFAaj7mYKscbAjeRwv5dNumXSrUfU7SJEYeaPn3+59vlvF0h+i5SEpPYWNfHbpAhdjSpIYfvqo7WA0Uv9i7hexu8FIJd79AAF5u3DhqJtFBaP8R4+zSVFuQPGjpSmQHvMxHLnVGzuXR/VupmiVky5Vfz133Ljh7VIsRxWcOPc8ES1wqdkmjuCOywYoYPpmDoyZ5XLPFsmUzBtLhKcjDO1Bg4BFo2T94L1gzO65IBMC3ossQvI3APTecst7thY8Ye+Z1LWgzrMr82cWUsqA2JLatza+GvpKDeyoHQZ73SR18KDUJxlCnidtDxg53Abj2rM2xPyKvTxlusa97P/D1KmHsgNjVcL25X9Bt4UoV7nQL6ahVdwdY0objzIOHnuZKAxBcyHEaVUMrF4PgLh9YkR3siE8HiEEm9lQng6gkM2hFGnkQ3hs4k44ChsS+H1nEeMYkvvcdYfweidTIzaIxhVMzCaM72zy1z+ZfBSMyHalTYTIpzJ+Gr3sWPuWnsiTGPujlApC6uyxqkQkXoohOxPSArfQNwIL4Nq/wGgWqAGygwAAA==";
    private static final Log log = LogFactory.getLog(ListBeanValidationDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addIdentity;
    protected JXTable dataTable;
    protected JScrollPane dataTableScrollePane;
    protected JTable errorTable;
    protected SwingListValidatorMessageTableModel errorTableModel;
    protected final ListBeanValidationDemoHandler handler = createHandler();
    protected PeopleTableModel model;
    protected JButton ok;
    protected JButton removeIdentity;
    protected BeanListValidator<People> validator;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ListBeanValidationDemo $DemoPanel0 = this;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected String[] getSources() {
        return addDefaultSources(
            "ListBeanValidationDemo.css",
            "/jaxx.demo.entities.People.java",
            "/jaxx.demo.entities.People-error-validation.xml",
            "/jaxx.demo.entities.People-info-validation.xml",
            "/jaxx.demo.entities.People-warning-validation.xml",
            "ListBeanValidationDemoHandler.java",
            "PeopleTableModel.java"
        );
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListBeanValidationDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ListBeanValidationDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ListBeanValidationDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ListBeanValidationDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ListBeanValidationDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public ListBeanValidationDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ListBeanValidationDemo() {
        $initialize();
    }

    public ListBeanValidationDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addIdentity(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addPeople();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        JOptionPane.showMessageDialog(this, ok.getText() + " clicked!", "onActionPerformed", JOptionPane.INFORMATION_MESSAGE);
    }

    public void doActionPerformed__on__removeIdentity(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removePeople();
    }

    public void doTableChanged__on__errorTableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateOkEnabled();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddIdentity() {
        return addIdentity;
    }

    public JXTable getDataTable() {
        return dataTable;
    }

    public JScrollPane getDataTableScrollePane() {
        return dataTableScrollePane;
    }

    public JTable getErrorTable() {
        return errorTable;
    }

    public SwingListValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public ListBeanValidationDemoHandler getHandler() {
        return handler;
    }

    public PeopleTableModel getModel() {
        return model;
    }

    public JButton getOk() {
        return ok;
    }

    public JButton getRemoveIdentity() {
        return removeIdentity;
    }

    public BeanListValidator<People> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDataTableScrollePane() {
        if (!allComponentsCreated) {
            return;
        }
        dataTableScrollePane.getViewport().add(dataTable);
    }

    protected void createAddIdentity() {
        $objectMap.put("addIdentity", addIdentity = new JButton());
        
        addIdentity.setName("addIdentity");
        addIdentity.setText(t("jaxx.demo.action.add"));
        addIdentity.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addIdentity"));
    }

    protected void createDataTable() {
        $objectMap.put("dataTable", dataTable = new JXTable());
        
        dataTable.setName("dataTable");
        dataTable.setAutoCreateRowSorter(true);
    }

    protected void createDataTableScrollePane() {
        $objectMap.put("dataTableScrollePane", dataTableScrollePane = new JScrollPane());
        
        dataTableScrollePane.setName("dataTableScrollePane");
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new JTable());
        
        errorTable.setName("errorTable");
        errorTable.setAutoCreateRowSorter(true);
        errorTable.setAutoResizeMode(2);
        errorTable.setCellSelectionEnabled(false);
        errorTable.setRowSelectionAllowed(true);
        errorTable.setSelectionMode(0);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingListValidatorMessageTableModel());
        
        errorTableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorTableModel"));
    }

    protected ListBeanValidationDemoHandler createHandler() {
        return new ListBeanValidationDemoHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = new PeopleTableModel());
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("jaxx.demo.action.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createRemoveIdentity() {
        $objectMap.put("removeIdentity", removeIdentity = new JButton());
        
        removeIdentity.setName("removeIdentity");
        removeIdentity.setText(t("jaxx.demo.action.remove"));
        removeIdentity.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeIdentity"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = BeanListValidator.newValidator(People.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(dataTableScrollePane, BorderLayout.CENTER);
        addChildrenToDataTableScrollePane();
        // inline complete setup of $JPanel1
        $JPanel1.add(addIdentity);
        $JPanel1.add(removeIdentity);
        $JPanel1.add(ok);
        // inline complete setup of $JPanel2
        $JPanel2.add($JScrollPane0);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorTable);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        $JPanel0.setBorder(BorderFactory.createTitledBorder("Form"));
        dataTable.setModel(model);
        $JPanel2.setBorder(BorderFactory.createTitledBorder("Messages"));
        errorTable.setModel(errorTableModel);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        createValidator();
        createErrorTableModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        SwingUtil.setComponentHeight($JPanel0,120);
        $JPanel0.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel0,250);
        createDataTableScrollePane();
        createDataTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,3,0,0));
        createAddIdentity();
        createRemoveIdentity();
        createOk();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        SwingUtil.setComponentHeight($JPanel2,200);
        $JPanel2.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel2,500);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createErrorTable();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (errorTable != null) {
                    errorTable.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (errorTable != null) {
                    $JScrollPane0.setColumnHeaderView(errorTable.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (errorTable != null) {
                    errorTable.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
    }

}