/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.swing.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class JToggleButtonDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTO28TQRAeO7ETxwnEtvISAZlgEBLSGWpHIS9ZwTIPYYoIN6x9K/ui8+2yOxcfFIifwE+AngaJjgpRUFPQIP4CQhS0iN3142w4EktccXeame+bb3a/ef0NElLAxSMSBJbwPXQ61KrsHB7ebRzRJu5T2RQORyag98TiEK9D2h7GJcKlelXDi314cY91OPOoN4IuVWFO4hOXyjaliHB+HNGUslgbpksB98WAdSgqivXlj+/xF/bzV3GAgCt1STVK/jRUOMl0FeKOjZBVnY5J0SVeS8kQjtdSehd0bM8lUt4hHfoYnsFMFZKcCEWGsDH5yIbD4AOOkC7s0w67RzzqXke4ZsTaKmI1BxSW7CoFVuUBa7VcuusjMk9jODcsSYRk4WCXBQq+MjZrD6dTui41LJ9StAhrep4gilyXzYfV2GX6NzMeTmBbUBqRmC1UqqRhpsmOtTDRfq2Ac2NS1YVb4YWHNxKrQ0L4KoywWv/bI/dVqueO1T/coQlN9tdy7vO7r2/Lo5ZYiiwdcbS6Ki4YpwId3fpszw8+Om7xNuGlOqQkddU6GLuvRwir9dNKnOqX0XBLw60DItuKIjHz5f2H5UefpiBehjmXEbtMdP0tSOlzlW3m2gG/uW0UzXdn1XtRa0PItZlwnjIPibvjOi2vY+yX3XQ81/FonqDya8NHuhWoU1mPOJWhtEbq489c7c324GRiSunaP8vD00k8hGSvm1mX/iZErkeaS+rbLHR81A7E9HeB9+18wbw3okbPHOsLaY4MrksvB77+XDET6L+rExNOIw1O4lg8lUOHb5zAkPtvhqXJGBDObNoESb7heLZat61othXF9htXTGxw4wUAAA==";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.swing.JToggleButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JToggleButton one;
    protected javax.swing.JToggleButton three;
    protected javax.swing.JToggleButton two;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JToggleButtonDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.HBox $HBox0;
    private javax.swing.JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JToggleButtonDemo() {
        super();
        $initialize();
    }

    public JToggleButtonDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JToggleButton getOne() {
        return one;
    }

    public javax.swing.JToggleButton getThree() {
        return three;
    }

    public javax.swing.JToggleButton getTwo() {
        return two;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.HBox get$HBox0() {
        return $HBox0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createOne() {
        $objectMap.put("one", one = new javax.swing.JToggleButton());
        
        one.setName("one");
        one.setText(_("1"));
    }

    protected void createThree() {
        $objectMap.put("three", three = new javax.swing.JToggleButton());
        
        three.setName("three");
        three.setText(_("3"));
    }

    protected void createTwo() {
        $objectMap.put("two", two = new javax.swing.JToggleButton());
        
        two.setName("two");
        two.setText(_("2"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($HBox0);
        // inline complete setup of $HBox0
        $HBox0.add(one);
        $HBox0.add(two);
        $HBox0.add(three);
        $HBox0.add($JLabel0);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new jaxx.runtime.swing.HBox());
        
        $HBox0.setName("$HBox0");
        $HBox0.setHorizontalAlignment(0);
        $HBox0.setVerticalAlignment(0);
        createOne();
        createTwo();
        createThree();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (one != null) {
                    $bindingSources.put("one.getModel()", one.getModel());
                    one.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    one.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (two != null) {
                    $bindingSources.put("two.getModel()", two.getModel());
                    two.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    two.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (three != null) {
                    $bindingSources.put("three.getModel()", three.getModel());
                    three.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    three.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (one != null && two != null && three != null) {
                    $JLabel0.setText(_("Total: " + ((one.isSelected() ? 1 : 0) + (two.isSelected() ? 2 : 0) + (three.isSelected() ? 3 : 0))));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (one != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("one.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    one.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (two != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("two.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    two.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (three != null) {
                    javax.swing.ButtonModel $target = ((javax.swing.ButtonModel) $bindingSources.remove("three.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    three.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
            }
        
            public void $pr$u0(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
    }

}