/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.types;

import java.awt.Insets;
import java.util.StringTokenizer;
import org.nuiton.jaxx.compiler.types.TypeConverter;

public class InsetsConverter
implements TypeConverter {
    @Override
    public Class<?>[] getSupportedTypes() {
        return new Class[]{Insets.class};
    }

    @Override
    public String getJavaCode(Object object) {
        Insets insets = (Insets)object;
        return "new Insets(" + insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right + ")";
    }

    @Override
    public Object convertFromString(String string, Class<?> type) {
        if (!Insets.class.equals(type)) {
            throw new IllegalArgumentException("unsupported type: " + type);
        }
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        int count = tokenizer.countTokens();
        if (count == 1) {
            int i = Integer.parseInt(tokenizer.nextToken().trim());
            return new Insets(i, i, i, i);
        }
        if (count == 4) {
            int[] insets = new int[count];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                insets[i] = Integer.parseInt(tokenizer.nextToken().trim());
                ++i;
            }
            return new Insets(insets[0], insets[1], insets[2], insets[3]);
        }
        throw new IllegalArgumentException("unable to convert string '" + string + "' to Insets");
    }
}

