/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: CompileFirstPassTask.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.13/jaxx-compiler/src/main/java/jaxx/compiler/tasks/CompileFirstPassTask.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.compiler.tasks;

import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

/**
 * First compile pass task to validate jaxx files and look after dependencies.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.2
 */
public class CompileFirstPassTask extends JAXXEngineTask {

    /** Logger */
    private static final Log log = LogFactory.getLog(CompileFirstPassTask.class);

    /** Task name */
    public static final String TASK_NAME = "CompileFirstPass";

    public CompileFirstPassTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        boolean success = true;

        JAXXCompilerFile[] undone = engine.getFilesToCompile();

        while (undone.length > 0) {

            // start a new round of compilation

            for (JAXXCompilerFile jaxxFile : undone) {

                boolean successForFile = treateFile(engine, jaxxFile);

                if (!successForFile) {

                    // something is wrong...
                    success = false;
                }
            }

            // prepare next round
            undone = engine.getFilesToCompile();
        }
        return success;
    }

    protected boolean treateFile(JAXXEngine engine,
                                 JAXXCompilerFile jaxxFile) throws Exception {

        boolean isVerbose = engine.isVerbose();

        if (isVerbose) {
            log.info("start " + jaxxFile.getClassName());
        }

        boolean success = true;

        CompilerConfiguration configuration = engine.getConfiguration();

        JAXXCompiler compiler = engine.newCompiler(jaxxFile);
        addStartProfileTime(engine, compiler);

        compiler.compileFirstPass();

        if (configuration.isAutoImportCss() && !compiler.isIdentCssFound()) {

            // check if we can add ident css file

            File cssFile = jaxxFile.getCssFile();

            if (log.isDebugEnabled()) {
                log.debug("test ident css file " + cssFile + " : " + isVerbose);
            }
            if (cssFile.exists()) {

                compiler.setIdentCssFound(true);

                if (isVerbose) {
                    log.info("Auto import of css " + cssFile);
                }
                // ok add it
                compiler.registerStyleSheetFile(cssFile);
            }
        }
        addEndProfileTime(engine, compiler);

        if (compiler.isFailed()) {
            success = false;
        }
        return success;
    }
}
