/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: JSliderHandler.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.10/jaxx-compiler/src/main/java/jaxx/compiler/tags/swing/JSliderHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.tags.swing;

import jaxx.compiler.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.tags.DefaultComponentHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

import javax.swing.JSlider;
import javax.swing.event.ChangeListener;

public class JSliderHandler extends DefaultComponentHandler {
    public static final String ATTRIBUTE_VALUE = "value";

    public JSliderHandler(ClassDescriptor beanClass) {
        super(beanClass);
        if (!ClassDescriptorHelper.getClassDescriptor(JSlider.class).isAssignableFrom(beanClass)) {
            throw new IllegalArgumentException(getClass().getName() + " does not support the class " + beanClass.getName());
        }
    }

    @Override
    protected int getAttributeOrdering(Attr attr) {
        if (attr.getName().equals(ATTRIBUTE_VALUE)) {
            return 1;
        } else {
            return super.getAttributeOrdering(attr);
        }
    }

    @Override
    protected void setDefaults(CompiledObject object, Element tag, JAXXCompiler compiler) throws CompilerException {
        super.setDefaults(object, tag, compiler);
        setAttribute(object, ATTRIBUTE_VALUE, "0", false, compiler);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("getValue", ChangeListener.class, "model");
    }
}
