/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tasks;

import java.io.File;
import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.tasks.JAXXEngineTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompileFirstPassTask
extends JAXXEngineTask {
    private static final Log log = LogFactory.getLog(CompileFirstPassTask.class);
    private static final long serialVersionUID = -1L;
    public static final String TASK_NAME = "CompileFirstPass";
    protected boolean compiled;

    public CompileFirstPassTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        boolean success = true;
        this.compiled = true;
        while (this.compiled) {
            JAXXCompilerFile[] files;
            this.compiled = false;
            for (JAXXCompilerFile jaxxFile : files = engine.getCompilingFiles()) {
                boolean successForFile = this.treateFile(engine, jaxxFile);
                if (successForFile) continue;
                success = false;
            }
        }
        return success;
    }

    protected boolean treateFile(JAXXEngine engine, JAXXCompilerFile jaxxFile) throws Exception {
        JAXXCompiler compiler;
        boolean isVerbose = engine.isVerbose();
        if (isVerbose) {
            log.info((Object)(this.getName() + " for " + jaxxFile.getClassName()));
        }
        if ((compiler = jaxxFile.getCompiler()) != null) {
            return true;
        }
        boolean success = true;
        this.compiled = true;
        CompilerConfiguration configuration = engine.getConfiguration();
        compiler = engine.newCompiler(jaxxFile);
        this.addStartProfileTime(engine, compiler);
        compiler.compileFirstPass();
        if (configuration.isAutoImportCss() && !compiler.isIdentCssFound()) {
            File cssFile = jaxxFile.getCssFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("test ident css file " + cssFile + " : " + isVerbose));
            }
            if (cssFile.exists()) {
                compiler.setIdentCssFound(true);
                if (isVerbose) {
                    log.info((Object)("Auto import of css " + cssFile));
                }
                compiler.registerStyleSheetFile(cssFile);
            }
        }
        this.addEndProfileTime(engine, compiler);
        if (compiler.isFailed()) {
            success = false;
        }
        return success;
    }
}

