/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.finalizers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerException;
import jaxx.compiler.EventHandler;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFinalizer;
import jaxx.compiler.binding.DataBinding;
import jaxx.compiler.binding.DefaultJAXXBindingWriter;
import jaxx.compiler.binding.JAXXBindingWriter;
import jaxx.compiler.binding.SimpleJAXXObjectBindingWriter;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MemberDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.Base64Coder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultFinalizer
implements JAXXCompilerFinalizer {
    protected static final Log log = LogFactory.getLog(DefaultFinalizer.class);
    private static final String PARAMETER_NAME_$BINDING = "$binding";
    public static final String FIELD_NAME_$BINDING_SOURCES = "$bindingSources";
    public static final String FIELD_NAME_$OBJECT_MAP = "$objectMap";
    public static final String FIELD_NAME_$ACTIVE_BINDINGS = "$activeBindings";
    public static final String FIELD_NAME_ALL_COMPONENTS_CREATED = "allComponentsCreated";
    public static final String FIELD_NAME_CONTEXT_INITIALIZED = "contextInitialized";
    public static final String FIELD_NAME_$PREVIOUS_VALUES = "$previousValues";
    public static final String FIELD_NAME_$BINDINGS = "$bindings";
    public static final String FIELD_NAME_$PROPERTY_CHANGE_SUPPORT = "$propertyChangeSupport";
    public static final String FIELD_NAME_DELEGATE_CONTEXT = "delegateContext";
    public static final String FIELD_NAME_SERIAL_VERSION_UID = "serialVersionUID";
    public static final String FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR = "$jaxxObjectDescriptor";
    public static final String METHOD_NAME_$GET_JAXXOBJECT_DESCRIPTOR = "$getJAXXObjectDescriptor";
    public static final String METHOD_NAME_$REGISTER_DEFAULT_BINDINGS = "$registerDefaultBindings";
    public static final String METHOD_NAME_REGISTER_DATA_BINDING = "registerDataBinding";
    public static final String METHOD_NAME_REMOVE_DATA_BINDING = "removeDataBinding";
    public static final String METHOD_NAME_APPLY_DATA_BINDING = "applyDataBinding";
    public static final String METHOD_NAME_PROCESS_DATA_BINDING = "processDataBinding";
    public static final String METHOD_NAME_FIRE_PROPERTY_CHANGE = "firePropertyChange";
    public static final String METHOD_NAME_$GET_PROPERTY_CHANGE_SUPPORT = "$getPropertyChangeSupport";
    public static final String METHOD_NAME_$INITIALIZE = "$initialize";
    public static final String METHOD_NAME_$COMPLETE_SETUP = "$completeSetup";
    public static final String METHOD_NAME_$AFTER_COMPLETE_SETUP = "$afterCompleteSetup";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_VOID = "void";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_OBJECT = "Object";
    protected static final JavaField SERIAL_VERSION_UID_FIELD = JavaFileGenerator.newField(26, "long", "serialVersionUID", false, "1L");
    protected static final JavaField ACTIVE_BINDINGS_FIELD = JavaFileGenerator.newField(4, "java.util.List<Object>", "$activeBindings", false, "new ArrayList<Object>()");
    protected static final JavaField BINDING_SOURCES_FIELD = JavaFileGenerator.newField(4, "Map<String, Object>", "$bindingSources", false, "new HashMap<String, Object>()");
    protected static final JavaField OBJECT_MAP_FIELD = JavaFileGenerator.newField(4, "Map<String, Object>", "$objectMap", true, "new HashMap<String, Object>()");
    protected static final JavaField ALL_COMPONENTS_CREATED_FIELD = JavaFileGenerator.newField(2, "boolean", "allComponentsCreated", false);
    protected static final JavaField CONTEXT_INITIALIZED = JavaFileGenerator.newField(2, "boolean", "contextInitialized", false, "true");
    protected static final JavaField PREVIOUS_VALUES_FIELD = JavaFileGenerator.newField(4, "Map<?,?>", "$previousValues", false, "new java.util.HashMap<Object, Object>()");
    protected static final JavaField BINDINGS_FIELD = JavaFileGenerator.newField(20, "Map<String, JAXXBinding>", "$bindings", false, "new java.util.TreeMap<String, JAXXBinding>()");
    protected static final JavaField PROPERTY_CHANGE_SUPPORT_FIELD = JavaFileGenerator.newField(4, "PropertyChangeSupport", "$propertyChangeSupport", false);
    protected static final JavaMethod GET_CONTEXT_VALUE_METHOD = JavaFileGenerator.newMethod(1, "<T> T", "getContextValue", "return delegateContext.getContextValue(clazz, null);", true, new JavaArgument("Class<T>", "clazz"));
    protected static final JavaMethod GET_CONTEXT_VALUE_NAMED_METHOD = JavaFileGenerator.newMethod(1, "<T> T", "getContextValue", "return delegateContext.getContextValue(clazz, name);", true, new JavaArgument("Class<T>", "clazz"), new JavaArgument("String", "name"));
    protected static final JavaMethod SET_CONTEXT_VALUE_NAMED_METHOD = JavaFileGenerator.newMethod(1, "<T> void", "setContextValue", "delegateContext.setContextValue(o, name);", true, new JavaArgument("T", "o"), new JavaArgument("String", "name"));
    protected static final JavaMethod SET_CONTEXT_VALUE_METHOD = JavaFileGenerator.newMethod(1, "<T> void", "setContextValue", "delegateContext.setContextValue(o, null);", true, new JavaArgument("T", "o"));
    protected static final JavaMethod REMOVE_CONTEXT_VALUE_NAMED_METHOD = JavaFileGenerator.newMethod(1, "<T> void", "removeContextValue", "delegateContext.removeContextValue(clazz, name);", true, new JavaArgument("Class<T>", "clazz"), new JavaArgument("String", "name"));
    protected static final JavaMethod REMOVE_CONTEXT_VALUE_METHOD = JavaFileGenerator.newMethod(1, "<T> void", "removeContextValue", "delegateContext.removeContextValue(clazz, null);", true, new JavaArgument("Class<T>", "clazz"));
    protected static final JavaMethod GET_PARENT_CONTAINER_MORE_METHOD = JavaFileGenerator.newMethod(1, "<O extends Container> O", "getParentContainer", "return SwingUtil.getParentContainer(source, clazz);", true, new JavaArgument("Object", "source"), new JavaArgument("Class<O>", "clazz"));
    protected static final JavaMethod GET_PARENT_CONTAINER_METHOD = JavaFileGenerator.newMethod(1, "<O extends Container> O", "getParentContainer", "return SwingUtil.getParentContainer(this, clazz);", true, new JavaArgument("Class<O>", "clazz"));
    protected static final JavaMethod GET_OBJECT_BY_ID_METHOD = JavaFileGenerator.newMethod(1, "Object", "getObjectById", "return $objectMap.get(id);", true, new JavaArgument("String", "id"));
    protected static final JavaMethod GET_JAXX_OBJECT_DESCRIPTOR_METHOD = JavaFileGenerator.newMethod(9, "JAXXObjectDescriptor", "$getJAXXObjectDescriptor", "return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);", false, new JavaArgument[0]);
    protected static final JavaMethod PROCESS_DATA_BINDING_METHOD = JavaFileGenerator.newMethod(1, "void", "processDataBinding", "processDataBinding($binding, false);", true, new JavaArgument("String", "$binding"));
    protected static final JavaMethod REGISTER_DATA_BINDING_METHOD = JavaFileGenerator.newMethod(1, "void", "registerDataBinding", "$bindings.put(binding.getId(), binding);", true, new JavaArgument(JAXXBinding.class.getSimpleName(), "binding"));
    protected static final JavaMethod GET_DATA_BINDING_METHOD = JavaFileGenerator.newMethod(1, JAXXBinding.class.getSimpleName() + "[]", "getDataBindings", "return $bindings.values().toArray(new " + JAXXBinding.class.getSimpleName() + "[" + "$bindings" + ".size()]);", true, new JavaArgument[0]);
    protected static final JavaMethod FIRE_PROPERTY_CHANGE_METHOD = JavaFileGenerator.newMethod(1, "void", "firePropertyChange", "super.firePropertyChange(propertyName, oldValue, newValue);", true, new JavaArgument("String", "propertyName"), new JavaArgument("Object", "oldValue"), new JavaArgument("Object", "newValue"));
    protected static final JavaMethod FIRE_PROPERTY_CHANGE_NAMED_METHOD = JavaFileGenerator.newMethod(1, "void", "firePropertyChange", "$getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);", true, new JavaArgument("String", "propertyName"), new JavaArgument("Object", "oldValue"), new JavaArgument("Object", "newValue"));
    protected static final JavaMethod GET_PROPERTY_CHANGE_SUPPORT_METHOD = JavaFileGenerator.newMethod(0, PropertyChangeSupport.class.getSimpleName(), "$getPropertyChangeSupport", "if ($propertyChangeSupport == null)\n    $propertyChangeSupport = new PropertyChangeSupport(this);\nreturn $propertyChangeSupport;", false, new JavaArgument[0]);
    protected static final JavaMethod ADD_PROPERTY_CHANGE_SUPPORT_METHOD = JavaFileGenerator.newMethod(1, "void", "addPropertyChangeListener", "$getPropertyChangeSupport().addPropertyChangeListener(listener);", true, new JavaArgument(PropertyChangeListener.class.getSimpleName(), "listener"));
    protected static final JavaMethod ADD_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD = JavaFileGenerator.newMethod(1, "void", "addPropertyChangeListener", "$getPropertyChangeSupport().addPropertyChangeListener(property, listener);", true, new JavaArgument("String", "property"), new JavaArgument(PropertyChangeListener.class.getSimpleName(), "listener"));
    protected static final JavaMethod REMOVE_PROPERTY_CHANGE_SUPPORT_METHOD = JavaFileGenerator.newMethod(1, "void", "removePropertyChangeListener", "$getPropertyChangeSupport().removePropertyChangeListener(listener);", true, new JavaArgument(PropertyChangeListener.class.getSimpleName(), "listener"));
    protected static final JavaMethod REMOVE_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD = JavaFileGenerator.newMethod(1, "void", "removePropertyChangeListener", "$getPropertyChangeSupport().removePropertyChangeListener(property, listener);", true, new JavaArgument("String", "property"), new JavaArgument(PropertyChangeListener.class.getSimpleName(), "listener"));
    private static final String PARAMETER_NAME_PARENT_CONTEXT = "parentContext";
    protected static final JAXXBindingWriter[] bindingWriters = new JAXXBindingWriter[]{new SimpleJAXXObjectBindingWriter(), new DefaultJAXXBindingWriter()};

    @Override
    public boolean accept(JAXXCompiler compiler) {
        return true;
    }

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        String fullClassName;
        String string = fullClassName = packageName != null ? packageName + "." + className : className;
        if (root == null) {
            throw new CompilerException("root tag can not be null");
        }
        ClassDescriptor superclass = root.getObjectClass();
        boolean superclassIsJAXXObject = ClassDescriptorLoader.getClassDescriptor(JAXXObject.class).isAssignableFrom(superclass);
        javaFile.setModifiers(1);
        javaFile.setName(fullClassName);
        javaFile.setSuperClass(JAXXCompiler.getCanonicalName(superclass));
        javaFile.setSuperclassIsJAXXObject(superclassIsJAXXObject);
        javaFile.addInterfaces(compiler.getExtraInterfaces());
        javaFile.setAbstractClass(compiler.isAbstractClass());
        javaFile.setGenericType(compiler.getGenericType());
        javaFile.setSuperGenericType(compiler.getSuperGenericType());
        if (!superclassIsJAXXObject) {
            javaFile.addInterface(JAXXObject.class.getSimpleName());
        }
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        DataBinding[] bindings;
        int nbBindings;
        MethodDescriptor[] methods;
        FieldDescriptor[] scriptFields;
        String fullClassName = javaFile.getName();
        String jaxxContextImplementorClass = compiler.getConfiguration().getJaxxContextClass().getName();
        boolean superclassIsJAXXObject = javaFile.isSuperclassIsJAXXObject();
        if (!superclassIsJAXXObject) {
            javaFile.addImport(JAXXObject.class);
        }
        javaFile.addImport(JAXXContext.class);
        javaFile.addImport(JAXXObjectDescriptor.class);
        javaFile.addImport(JAXXBinding.class);
        if (!superclassIsJAXXObject) {
            if (compiler.getConfiguration().isAddLogger()) {
                javaFile.addImport(Log.class);
                javaFile.addImport(LogFactory.class);
                javaFile.addSimpleField(JavaFileGenerator.newField(28, "Log", "log", false, "LogFactory.getLog(" + fullClassName + ".class)"));
            }
            javaFile.addField(OBJECT_MAP_FIELD);
            javaFile.addMethod(GET_OBJECT_BY_ID_METHOD);
            javaFile.addSimpleField(BINDING_SOURCES_FIELD);
            javaFile.addSimpleField(ACTIVE_BINDINGS_FIELD);
            javaFile.addSimpleField(BINDINGS_FIELD);
            javaFile.addMethod(REGISTER_DATA_BINDING_METHOD);
            javaFile.addMethod(GET_DATA_BINDING_METHOD);
            javaFile.addMethod(this.createApplyDataBindingMethod());
            javaFile.addMethod(this.createProcessDataBindingMethod());
            javaFile.addMethod(this.createRemoveDataBindingMethod());
            javaFile.addField(JavaFileGenerator.newField(20, JAXXContext.class.getSimpleName(), FIELD_NAME_DELEGATE_CONTEXT, true, "new " + jaxxContextImplementorClass + "()"));
            javaFile.addMethod(SET_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(SET_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(GET_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(GET_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(REMOVE_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(REMOVE_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(GET_PARENT_CONTAINER_METHOD);
            javaFile.addMethod(GET_PARENT_CONTAINER_MORE_METHOD);
            this.addPropertyChangeSupport(root, javaFile);
            javaFile.addMethod(PROCESS_DATA_BINDING_METHOD);
        }
        javaFile.addSimpleField(SERIAL_VERSION_UID_FIELD);
        javaFile.addSimpleField(ALL_COMPONENTS_CREATED_FIELD);
        boolean overrideContextInitialized = false;
        for (FieldDescriptor f : scriptFields = compiler.getScriptFields()) {
            if (!FIELD_NAME_CONTEXT_INITIALIZED.equals(f.getName())) continue;
            overrideContextInitialized = true;
            break;
        }
        if (!overrideContextInitialized) {
            javaFile.addSimpleField(CONTEXT_INITIALIZED);
        }
        javaFile.addSimpleField(this.createJAXXObjectDescriptorField(compiler, javaFile));
        if (compiler.getStylesheet() != null) {
            boolean needField = true;
            if (superclassIsJAXXObject) {
                JAXXCompiler parentCompiler;
                ClassDescriptor superclass = root.getObjectClass();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("superclass : " + superclass));
                }
                if ((parentCompiler = compiler.getEngine().getJAXXCompiler(superclass.getName())) != null) {
                    needField = parentCompiler.getStylesheet() == null;
                } else {
                    try {
                        superclass.getDeclaredFieldDescriptor(PREVIOUS_VALUES_FIELD.getName());
                        needField = false;
                    }
                    catch (NoSuchFieldException ex) {
                        // empty catch block
                    }
                }
                if (needField && log.isDebugEnabled()) {
                    log.debug((Object)("no " + PREVIOUS_VALUES_FIELD.getName() + " field in super class"));
                }
            }
            if (needField) {
                javaFile.addSimpleField(PREVIOUS_VALUES_FIELD);
            }
        }
        boolean constructorDetected = false;
        for (MethodDescriptor m : methods = compiler.getScriptMethods()) {
            try {
                m.getReturnType();
                if (!className.equals(m.getName())) continue;
                constructorDetected = true;
                break;
            }
            catch (Exception e) {
                log.warn((Object)("could not find return type " + m));
            }
        }
        if (!constructorDetected) {
            javaFile.addMethod(this.createConstructor(compiler, className, superclassIsJAXXObject));
            javaFile.addMethod(this.createConstructorWithInitialContext(compiler, className, superclassIsJAXXObject));
        }
        boolean hasDataBindings = (nbBindings = (bindings = compiler.getBindingHelper().getDataBindings()).length) > 0;
        javaFile.addMethod(this.createInitializer(compiler, nbBindings));
        javaFile.addMethod(GET_JAXX_OBJECT_DESCRIPTOR_METHOD);
        javaFile.addBodyCode(compiler.getBodyCode().toString());
        if (hasDataBindings) {
            javaFile.addMethod(this.createRegisterDefaultBindingsMethod(compiler));
            for (JAXXBindingWriter writer : bindingWriters) {
                if (!writer.isUsed()) continue;
                compiler.getJavaFile().addImport(writer.getType());
            }
            for (DataBinding binding : bindings) {
                String constantId = binding.getConstantId();
                compiler.addSimpleField(JavaFileGenerator.newField((constantId.startsWith("BINDING_$") ? 2 : 1) | 0x10 | 8, TYPE_STRING, constantId, false, TypeManager.getJavaCode(binding.getRealId())));
            }
        }
        javaFile.addMethod(this.createCompleteSetupMethod(compiler, javaFile));
        this.addEventHandlers(compiler, javaFile);
    }

    protected JavaMethod createRegisterDefaultBindingsMethod(JAXXCompiler compiler) {
        DataBinding[] bindings = compiler.getBindingHelper().getDataBindings();
        StringBuilder initCode = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        JavaFileGenerator generator = new JavaFileGenerator(eol, true);
        initCode.append("// register ").append(bindings.length).append(" data bindings").append(eol);
        block0: for (DataBinding binding : bindings) {
            for (JAXXBindingWriter writer : bindingWriters) {
                if (!writer.accept(binding)) continue;
                writer.write(binding, generator, initCode);
                continue block0;
            }
        }
        return JavaFileGenerator.newMethod(2, TYPE_VOID, METHOD_NAME_$REGISTER_DEFAULT_BINDINGS, initCode.toString(), false, new JavaArgument[0]);
    }

    protected JavaField createJAXXObjectDescriptorField(JAXXCompiler compiler, JavaFile javaFile) {
        try {
            JAXXObjectDescriptor descriptor = compiler.getJAXXObjectDescriptor();
            String data = Base64Coder.serialize((Object)descriptor, (boolean)true);
            int sizeLimit = 65000;
            if (data.length() < sizeLimit) {
                return JavaFileGenerator.newField(26, TYPE_STRING, FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR, false, TypeManager.getJavaCode(data));
            }
            StringBuffer initializer = new StringBuffer();
            for (int i = 0; i < data.length(); i += sizeLimit) {
                String name = FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR + i;
                javaFile.addField(new JavaField(10, TYPE_STRING, name, false, TypeManager.getJavaCode(data.substring(i, Math.min(i + sizeLimit, data.length())))));
                if (initializer.length() > 0) {
                    initializer.append(" + ");
                }
                initializer.append("String.valueOf(").append(name).append(")");
            }
            return JavaFileGenerator.newField(26, TYPE_STRING, FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR, false, initializer.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
    }

    protected void addPropertyChangeSupport(CompiledObject root, JavaFile javaFile) {
        int modifiers;
        ClassDescriptor currentClass = root.getObjectClass();
        MemberDescriptor firePropertyChange = null;
        while (firePropertyChange == null && currentClass != null) {
            try {
                firePropertyChange = currentClass.getDeclaredMethodDescriptor(METHOD_NAME_FIRE_PROPERTY_CHANGE, ClassDescriptorLoader.getClassDescriptor(String.class), ClassDescriptorLoader.getClassDescriptor(Object.class), ClassDescriptorLoader.getClassDescriptor(Object.class));
            }
            catch (NoSuchMethodException e) {
                currentClass = currentClass.getSuperclass();
            }
        }
        int n = modifiers = firePropertyChange != null ? firePropertyChange.getModifiers() : 0;
        if (Modifier.isPublic(modifiers)) {
            return;
        }
        if (Modifier.isProtected(modifiers)) {
            javaFile.addMethod(FIRE_PROPERTY_CHANGE_METHOD);
        } else {
            javaFile.addImport(PropertyChangeListener.class);
            javaFile.addImport(PropertyChangeSupport.class);
            javaFile.addField(PROPERTY_CHANGE_SUPPORT_FIELD);
            javaFile.addMethod(GET_PROPERTY_CHANGE_SUPPORT_METHOD);
            javaFile.addMethod(ADD_PROPERTY_CHANGE_SUPPORT_METHOD);
            javaFile.addMethod(ADD_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD);
            javaFile.addMethod(REMOVE_PROPERTY_CHANGE_SUPPORT_METHOD);
            javaFile.addMethod(REMOVE_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD);
            javaFile.addMethod(FIRE_PROPERTY_CHANGE_NAMED_METHOD);
        }
    }

    protected void addEventHandlers(JAXXCompiler compiler, JavaFile javaFile) {
        for (Map.Entry<String, Map<ClassDescriptor, List<EventHandler>>> e1 : compiler.getEventHandlers().entrySet()) {
            for (Map.Entry<ClassDescriptor, List<EventHandler>> e2 : e1.getValue().entrySet()) {
                for (EventHandler handler : e2.getValue()) {
                    String methodName = compiler.getEventHandlerMethodName(handler);
                    MethodDescriptor listenerMethod = handler.getListenerMethod();
                    if (listenerMethod.getParameterTypes().length != 1) {
                        throw new CompilerException("Expected event handler " + listenerMethod.getName() + " of class " + handler.getListenerClass() + " to have exactly one argument");
                    }
                    javaFile.addMethod(JavaFileGenerator.newMethod(1, TYPE_VOID, methodName, handler.getJavaCode(), false, new JavaArgument(JAXXCompiler.getCanonicalName(listenerMethod.getParameterTypes()[0]), "event")));
                }
            }
        }
    }

    protected JavaMethod createConstructor(JAXXCompiler compiler, String className, boolean superclassIsJAXXObject) throws CompilerException {
        StringBuffer code = new StringBuffer();
        String constructorParams = compiler.getRootObject().getConstructorParams();
        String eol = JAXXCompiler.getLineSeparator();
        if (constructorParams != null) {
            code.append("        super(").append(constructorParams).append(");").append(eol);
        } else if (superclassIsJAXXObject) {
            code.append("        super();").append(eol);
        }
        code.append("$initialize();");
        code.append(eol);
        return JavaFileGenerator.newMethod(1, null, className, code.toString(), false, new JavaArgument[0]);
    }

    protected JavaMethod createConstructorWithInitialContext(JAXXCompiler compiler, String className, boolean superclassIsJAXXObject) throws CompilerException {
        StringBuffer code = new StringBuffer();
        String constructorParams = compiler.getRootObject().getConstructorParams();
        String eol = JAXXCompiler.getLineSeparator();
        if (constructorParams != null) {
            if (superclassIsJAXXObject) {
                constructorParams = "parentContext, " + constructorParams;
            }
            code.append("        super(").append(constructorParams).append(");").append(eol);
        } else if (superclassIsJAXXObject) {
            code.append("        super(parentContext);").append(eol);
        }
        if (!superclassIsJAXXObject) {
            code.append(Util.class.getSimpleName()).append(".initContext(this, parentContext);");
            code.append(eol);
        }
        code.append("$initialize();");
        code.append(eol);
        return JavaFileGenerator.newMethod(1, null, className, code.toString(), false, new JavaArgument(JAXXContext.class.getSimpleName(), PARAMETER_NAME_PARENT_CONTEXT));
    }

    public JavaMethod createInitializer(JAXXCompiler compiler, int nbBindings) throws CompilerException {
        String eol = JAXXCompiler.getLineSeparator();
        StringBuffer code = new StringBuffer();
        CompiledObject root = compiler.getRootObject();
        code.append("if (allComponentsCreated || !contextInitialized) {").append(eol);
        code.append("    return;").append(eol);
        code.append("}").append(eol);
        if (nbBindings > 0) {
            code.append("// registers ").append(nbBindings).append(" data bindings").append(eol);
            code.append("$registerDefaultBindings();").append(eol);
        }
        code.append("$objectMap.put(").append(TypeManager.getJavaCode(root.getId())).append(", this);").append(eol);
        Iterator<CompiledObject> i = compiler.getObjectCreationOrder();
        boolean lastWasMethodCall = false;
        while (i.hasNext()) {
            CompiledObject object = i.next();
            if (object == root) continue;
            CompiledObjectDecorator decorator = object.getDecorator();
            lastWasMethodCall = decorator.createInitializer(compiler, root, object, code, lastWasMethodCall);
        }
        root.getDecorator().createInitializer(compiler, root, root, code, lastWasMethodCall);
        if (compiler.getInitializer().length() > 0) {
            code.append(compiler.getInitializer());
        }
        code.append("$completeSetup();").append(eol);
        return JavaFileGenerator.newMethod(2, TYPE_VOID, METHOD_NAME_$INITIALIZE, code.toString(), false, new JavaArgument[0]);
    }

    protected JavaMethod createCompleteSetupMethod(JAXXCompiler compiler, JavaFile javaFile) {
        MethodDescriptor method;
        StringBuffer code = new StringBuffer();
        code.append("allComponentsCreated = true;");
        String eol = JAXXCompiler.getLineSeparator();
        code.append(eol);
        for (CompiledObject object : compiler.getObjects().values()) {
            CompiledObjectDecorator decorator = object.getDecorator();
            code.append(decorator.createCompleteSetupMethod(compiler, object, javaFile));
        }
        String simpleBindingsCode = this.createInitBindingsCode(compiler);
        if (simpleBindingsCode != null && !simpleBindingsCode.isEmpty()) {
            code.append(simpleBindingsCode).append(eol);
        }
        if (compiler.getLateInitializer().length() > 0) {
            code.append("// late initializer").append(eol);
            code.append(compiler.getLateInitializer()).append(eol);
        }
        if ((method = compiler.getScriptMethod(METHOD_NAME_$AFTER_COMPLETE_SETUP)) != null) {
            code.append("$afterCompleteSetup();").append(eol);
        }
        return JavaFileGenerator.newMethod(2, TYPE_VOID, METHOD_NAME_$COMPLETE_SETUP, code.toString(), false, new JavaArgument[0]);
    }

    protected String createInitBindingsCode(JAXXCompiler compiler) {
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder result = new StringBuilder();
        DataBinding[] bindings = compiler.getBindingHelper().getDataBindings();
        if (bindings.length > 0) {
            result.append(eol).append("// apply ").append(bindings.length).append(" data bindings").append(eol);
            result.append(Util.class.getSimpleName()).append(".applyDataBinding(this, $bindings.keySet());").append(eol);
        }
        if ((bindings = compiler.getBindingHelper().getSimpleBindings()).length > 0) {
            StringBuilder initCode = new StringBuilder();
            for (DataBinding binding : bindings) {
                String binding1 = binding.getInitDataBinding();
                if (binding1 == null || binding1.trim().isEmpty()) continue;
                initCode.append(binding1);
            }
            if (initCode.length() > 0) {
                result.append(eol).append("// apply ").append(bindings.length).append(" property setters").append(eol);
                result.append(initCode.toString().trim());
            }
        }
        return result.toString();
    }

    protected JavaMethod createApplyDataBindingMethod() {
        StringBuilder buffer = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        buffer.append("if (allComponentsCreated && $bindings.containsKey($binding)) {").append(eol);
        buffer.append("    $bindings.get($binding).applyDataBinding();").append(eol);
        buffer.append("}");
        buffer.append(eol).append("processDataBinding($binding);");
        return JavaFileGenerator.newMethod(1, TYPE_VOID, METHOD_NAME_APPLY_DATA_BINDING, buffer.toString(), true, new JavaArgument(TYPE_STRING, PARAMETER_NAME_$BINDING));
    }

    protected JavaMethod createRemoveDataBindingMethod() {
        StringBuilder buffer = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        buffer.append("if (allComponentsCreated && $bindings.containsKey($binding)) {").append(eol);
        buffer.append("    $bindings.get($binding).removeDataBinding();").append(eol);
        buffer.append("}");
        return JavaFileGenerator.newMethod(1, TYPE_VOID, METHOD_NAME_REMOVE_DATA_BINDING, buffer.toString(), true, new JavaArgument(TYPE_STRING, PARAMETER_NAME_$BINDING));
    }

    protected JavaMethod createProcessDataBindingMethod() {
        StringBuffer code = new StringBuffer();
        String eol = JAXXCompiler.getLineSeparator();
        code.append("    if (!$force && $activeBindings.contains($binding)) { ").append(eol);
        code.append("    return;").append(eol);
        code.append("}").append(eol);
        code.append("$activeBindings.add($binding);").append(eol);
        code.append("try {").append(eol);
        code.append("    if (allComponentsCreated && $bindings.containsKey($binding)) {").append(eol);
        code.append("        $bindings.get($binding).processDataBinding();").append(eol);
        code.append("    }").append(eol);
        code.append("} finally {").append(eol);
        code.append("    $activeBindings.remove($binding);").append(eol);
        code.append("}").append(eol);
        return JavaFileGenerator.newMethod(1, TYPE_VOID, METHOD_NAME_PROCESS_DATA_BINDING, code.toString(), true, new JavaArgument(TYPE_STRING, PARAMETER_NAME_$BINDING), new JavaArgument(TYPE_BOOLEAN, "$force"));
    }
}

