/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaElement;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaFile
extends JavaElement {
    private static final Log log = LogFactory.getLog(JavaFile.class);
    protected static final String GETTER_PATTERN = "return %1$s;";
    protected static final String BOOLEAN_GETTER_PATTERN = "return %1$s !=null && %1$s;";
    protected static final String SETTER_PATTERN = "%1$s oldValue = this.%2$s;\nthis.%2$s = newValue;\nfirePropertyChange(%3$s, oldValue, newValue);";
    private List<String> imports = new ArrayList<String>();
    private List<JavaField> fields = new ArrayList<JavaField>();
    private List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private List<JavaFile> innerClasses = new ArrayList<JavaFile>();
    private String superClass;
    private List<String> interfaces;
    private StringBuffer rawBodyCode = new StringBuffer();
    private boolean superclassIsJAXXObject;
    private boolean abstractClass;
    private String genericType;
    private String superGenericType;

    public JavaFile() {
        super(0, "");
    }

    public JavaFile(int modifiers, String className, String superClass) {
        this(modifiers, className, superClass, null);
    }

    public JavaFile(int modifiers, String className, String superClass, List<String> interfaces) {
        super(modifiers, className);
        this.superClass = superClass;
        this.interfaces = interfaces;
    }

    public void addImport(String importString) {
        this.imports.add(importString);
    }

    public void addImport(Class<?> importString) {
        this.imports.add(importString.getName());
    }

    public String[] getImports() {
        return this.imports.toArray(new String[this.imports.size()]);
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public List<String> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<String>();
        }
        return this.interfaces;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public void setGenericType(String genericType) {
        this.genericType = genericType;
    }

    public void addMethod(JavaMethod method) {
        this.methods.add(method);
    }

    public List<JavaMethod> getMethods() {
        return this.methods;
    }

    public void addField(JavaField field) {
        this.addField(field, false);
    }

    public void addField(JavaField field, boolean javaBean) {
        this.addSimpleField(field);
        String id = field.getName();
        String capitalizedName = StringUtils.capitalize((String)id);
        String content = String.format(GETTER_PATTERN, id);
        this.addMethod(new JavaMethod(Modifier.isProtected(field.getModifiers()) ? 1 : 4, field.getType(), "get" + capitalizedName, null, null, content, field.isOverride()));
        if (javaBean) {
            String constantId = JAXXCompiler.convertVariableNameToConstantName("property" + capitalizedName);
            this.addSimpleField(JavaFileGenerator.newField(25, String.class.getSimpleName(), constantId, false, "\"" + id + "\""));
            if (Boolean.class.getName().equals(field.getType())) {
                content = String.format(BOOLEAN_GETTER_PATTERN, id);
                this.addMethod(new JavaMethod(1, field.getType(), "is" + capitalizedName, null, null, content, field.isOverride()));
            }
            content = String.format(SETTER_PATTERN, field.getType(), id, constantId);
            JavaArgument arg = new JavaArgument(field.getType(), "newValue");
            this.addMethod(new JavaMethod(1, "void", "set" + capitalizedName, new JavaArgument[]{arg}, null, content, field.isOverride()));
        }
    }

    public void addSimpleField(JavaField field) {
        this.fields.add(field);
    }

    public List<JavaField> getFields() {
        return this.fields;
    }

    public void addBodyCode(String bodyCode) {
        this.rawBodyCode.append(bodyCode);
    }

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public String getGenericType() {
        return this.genericType;
    }

    public List<JavaFile> getInnerClasses() {
        return this.innerClasses;
    }

    public StringBuffer getRawBodyCode() {
        return this.rawBodyCode;
    }

    public String getSuperGenericType() {
        return this.superGenericType;
    }

    public void addInterface(String canonicalName) {
        if (this.interfaces == null || !this.interfaces.contains(canonicalName)) {
            this.getInterfaces().add(canonicalName);
        }
    }

    public void addInterfaces(String[] canonicalNames) {
        if (canonicalNames == null) {
            return;
        }
        for (String canonicalName : canonicalNames) {
            if (this.interfaces != null && this.interfaces.contains(canonicalName)) continue;
            this.getInterfaces().add(canonicalName);
        }
    }

    public boolean isSuperclassIsJAXXObject() {
        return this.superclassIsJAXXObject;
    }

    public void setSuperclassIsJAXXObject(boolean superclassIsJAXXObject) {
        this.superclassIsJAXXObject = superclassIsJAXXObject;
    }

    public void setAbstractClass(boolean abstractClass) {
        this.abstractClass = abstractClass;
    }

    public void setSuperGenericType(String superGenericType) {
        this.superGenericType = superGenericType;
    }
}

