/*
 * *##% 
 * JAXX Compiler
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.compiler.finalizers;

import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.*;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.runtime.swing.Application;

import java.lang.reflect.Modifier;

/** @author chemit */
public class SwingFinalizer implements JAXXCompilerFinalizer {

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {

        if (ClassDescriptorLoader.getClassDescriptor(Application.class.getName()).isAssignableFrom(root.getObjectClass()) && !compiler.isMainDeclared()) {
            // TODO: check for existing main method first
            javaFile.addMethod(JavaFileGenerator.newMethod(
                    Modifier.PUBLIC | Modifier.STATIC,
                    "void",
                    "main",
                    "SwingUtilities.invokeLater(new Runnable() { public void run() { new " + className + "().setVisible(true); } });",
                    false,
                    new JavaArgument("String[]", "arg")));
        }
    }
}
