/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.java;

import java.lang.reflect.Modifier;
import java.util.Comparator;
import jaxx.compiler.java.JavaElement;

public class JavaField
extends JavaElement
implements Comparable<JavaField> {
    static final JavaFieldComparator COMPARATOR = new JavaFieldComparator();
    private String type;
    private String initializer;
    private boolean override;

    public JavaField(int modifiers, String type, String name, boolean override) {
        this(modifiers, type, name, override, null);
    }

    public JavaField(int modifiers, String type, String name, boolean override, String initializer) {
        super(modifiers, name);
        this.type = type;
        this.initializer = initializer;
        this.override = override;
    }

    public String getType() {
        return this.type;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public String getInitializer() {
        return this.initializer;
    }

    @Override
    public int compareTo(JavaField o) {
        return COMPARATOR.compare(this, o);
    }

    static class JavaFieldComparator
    implements Comparator<JavaField> {
        JavaFieldComparator() {
        }

        @Override
        public int compare(JavaField o1, JavaField o2) {
            int result = this.compareStatic(o1, o2);
            if (result != 0) {
                return result;
            }
            result = this.compareDataSource(o1, o2);
            if (result != 0) {
                return result;
            }
            result = this.compareVisibility(o1, o2);
            if (result != 0) {
                return result;
            }
            return o1.getName().compareTo(o2.getName());
        }

        public int compareStatic(JavaField o1, JavaField o2) {
            if (Modifier.isStatic(o1.getModifiers()) && !Modifier.isStatic(o2.getModifiers())) {
                return -1;
            }
            if (!Modifier.isStatic(o1.getModifiers()) && Modifier.isStatic(o2.getModifiers())) {
                return 1;
            }
            return 0;
        }

        public int compareDataSource(JavaField o1, JavaField o2) {
            if (o1.getName().startsWith("$DataSource") && !o2.getName().startsWith("$DataSource")) {
                return 1;
            }
            if (!o1.getName().startsWith("$DataSource") && o2.getName().startsWith("$DataSource")) {
                return -1;
            }
            return 0;
        }

        public int compareVisibility(JavaField o1, JavaField o2) {
            if (!Modifier.isPublic(o1.getModifiers()) && Modifier.isPublic(o2.getModifiers())) {
                return 1;
            }
            if (Modifier.isPublic(o1.getModifiers()) && !Modifier.isPublic(o2.getModifiers())) {
                return -1;
            }
            if (Modifier.isProtected(o1.getModifiers()) && !Modifier.isProtected(o2.getModifiers())) {
                return -1;
            }
            if (!Modifier.isProtected(o1.getModifiers()) && Modifier.isProtected(o2.getModifiers())) {
                return 1;
            }
            if (Modifier.isPrivate(o1.getModifiers()) && !Modifier.isPrivate(o2.getModifiers())) {
                return -1;
            }
            if (!Modifier.isPrivate(o1.getModifiers()) && Modifier.isPrivate(o2.getModifiers())) {
                return 1;
            }
            return 0;
        }
    }
}

