/*
 * Decompiled with CFR 0.152.
 */
package jaxx.tags;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import jaxx.CompilerException;
import jaxx.UnsupportedAttributeException;
import jaxx.compiler.JAXXCompiler;
import jaxx.tags.TagHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ScriptHandler
implements TagHandler {
    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        File scriptFile = null;
        NamedNodeMap attributes = tag.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String name = attribute.getName();
            String attrValue = attribute.getValue();
            if (name.equals("source")) {
                scriptFile = new File(compiler.getBaseDir(), attrValue.replace('/', File.separatorChar));
                StringWriter scriptBuffer = new StringWriter();
                try {
                    int c;
                    FileReader in = new FileReader(scriptFile);
                    char[] readBuffer = new char[2048];
                    while ((c = in.read(readBuffer)) > 0) {
                        scriptBuffer.write(readBuffer, 0, c);
                    }
                }
                catch (FileNotFoundException e) {
                    compiler.reportError("script file not found: " + scriptFile);
                }
                compiler.registerScript(scriptBuffer.toString(), scriptFile);
                continue;
            }
            if (name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI())) continue;
            throw new UnsupportedAttributeException(name);
        }
        StringBuffer script = new StringBuffer();
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    compiler.reportError("<script> tag may not contain child elements: " + tag);
                }
                case 3: 
                case 4: {
                    script.append(((Text)child).getData());
                }
            }
        }
        String scriptString = script.toString().trim();
        if (scriptString.length() > 0) {
            if (scriptFile != null) {
                compiler.reportError("<script> tag has both a source attribute and an inline script");
            }
            compiler.registerScript(script.toString());
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
    }
}

