/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jaxx.CompilerException;
import jaxx.UnsupportedAttributeException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JavaField;
import jaxx.parser.JavaParser;
import jaxx.parser.JavaParserConstants;
import jaxx.parser.JavaParserTreeConstants;
import jaxx.parser.SimpleNode;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.reflect.FieldDescriptor;
import jaxx.reflect.MethodDescriptor;
import jaxx.tags.DefaultObjectHandler;
import jaxx.tags.TagManager;
import jaxx.types.TypeManager;

public class DataSource {
    private String id;
    private String source;
    private JAXXCompiler compiler;
    private List<String> dependencySymbols = new ArrayList<String>();
    private StringBuffer addListenerCode = new StringBuffer();
    private StringBuffer removeListenerCode = new StringBuffer();
    private boolean compiled;
    private String objectCode;

    public DataSource(String id, String source, JAXXCompiler compiler) {
        this.id = id;
        this.source = source;
        this.compiler = compiler;
    }

    public String getId() {
        return this.id;
    }

    public String getSource() {
        return this.source;
    }

    public String getObjectCode() {
        return this.objectCode;
    }

    public boolean compile(String propertyChangeListenerCode) throws CompilerException {
        if (this.compiled) {
            throw new IllegalStateException(this + " has already been compiled");
        }
        String id = this.compiler.getAutoId(ClassDescriptorLoader.getClassDescriptor(this.getClass()));
        JavaParser p = new JavaParser(new StringReader(this.source + ";"));
        while (!p.Line()) {
            SimpleNode node = p.popNode();
            this.scanNode(node, id);
        }
        if (this.dependencySymbols.size() > 0) {
            this.compiler.addSimpleField(new JavaField(2, PropertyChangeListener.class.getName(), id, propertyChangeListenerCode));
        }
        this.compileListeners();
        this.compiled = true;
        return this.dependencySymbols.size() > 0;
    }

    public Collection<String> getDependencies() {
        return Collections.unmodifiableList(this.dependencySymbols);
    }

    private void scanNode(SimpleNode node, String listenerId) throws CompilerException {
        switch (node.getId()) {
            case 22: {
                break;
            }
            case 17: {
                break;
            }
            default: {
                int count = node.jjtGetNumChildren();
                for (int i = 0; i < count; ++i) {
                    this.scanNode(node.getChild(i), listenerId);
                }
                this.determineNodeType(node, listenerId);
            }
        }
    }

    private ClassDescriptor determineLiteralType(SimpleNode node) {
        assert (node.getId() == 66);
        if (node.jjtGetNumChildren() == 1) {
            int id = node.getChild(0).getId();
            if (id == 67) {
                return ClassDescriptorLoader.getClassDescriptor(Boolean.TYPE);
            }
            if (id == 68) {
                return ClassDescriptorLoader.getClassDescriptor(NULL.class);
            }
            throw new RuntimeException("Expected BooleanLiteral or NullLiteral, found " + JavaParserTreeConstants.jjtNodeName[id]);
        }
        int id = node.firstToken.kind;
        switch (id) {
            case 61: {
                if (node.firstToken.image.toLowerCase().endsWith("l")) {
                    return ClassDescriptorLoader.getClassDescriptor(Long.TYPE);
                }
                return ClassDescriptorLoader.getClassDescriptor(Integer.TYPE);
            }
            case 70: {
                return ClassDescriptorLoader.getClassDescriptor(Character.TYPE);
            }
            case 65: {
                if (node.firstToken.image.toLowerCase().endsWith("f")) {
                    return ClassDescriptorLoader.getClassDescriptor(Float.TYPE);
                }
                return ClassDescriptorLoader.getClassDescriptor(Double.TYPE);
            }
            case 71: {
                return ClassDescriptorLoader.getClassDescriptor(String.class);
            }
        }
        throw new RuntimeException("Expected literal token, found " + JavaParserConstants.tokenImage[id]);
    }

    private ClassDescriptor scanCompoundSymbol(String symbol, ClassDescriptor contextClass, boolean isMethod, String listenerId) {
        String[] tokens = symbol.split("\\s*\\.\\s*");
        StringBuffer currentSymbol = new StringBuffer();
        StringBuffer tokensSeenSoFar = new StringBuffer();
        boolean recognizeClassNames = true;
        for (int j = 0; j < tokens.length - (isMethod ? 1 : 0); ++j) {
            boolean accepted;
            block11: {
                accepted = false;
                if (tokensSeenSoFar.length() > 0) {
                    tokensSeenSoFar.append('.');
                }
                tokensSeenSoFar.append(tokens[j]);
                if (currentSymbol.length() > 0) {
                    currentSymbol.append('.');
                }
                currentSymbol.append(tokens[j]);
                if (currentSymbol.indexOf(".") == -1) {
                    String memberName = currentSymbol.toString();
                    CompiledObject object = this.compiler.getCompiledObject(memberName);
                    if (object != null) {
                        contextClass = object.getObjectClass();
                        currentSymbol.setLength(0);
                        accepted = true;
                        recognizeClassNames = false;
                    } else {
                        try {
                            FieldDescriptor field = contextClass.getFieldDescriptor(memberName);
                            this.trackMemberIfPossible(tokensSeenSoFar.toString(), contextClass, field.getName(), false, listenerId);
                            contextClass = field.getType();
                            currentSymbol.setLength(0);
                            accepted = true;
                            recognizeClassNames = false;
                        }
                        catch (NoSuchFieldException e) {
                            FieldDescriptor[] newFields;
                            if (j != 0 && (j != 1 || !tokens[0].equals(this.compiler.getRootObject().getId()))) break block11;
                            for (FieldDescriptor newField : newFields = this.compiler.getScriptFields()) {
                                if (!newField.getName().equals(memberName)) continue;
                                this.addListener(tokensSeenSoFar.toString(), null, "addPropertyChangeListener(\"" + memberName + "\", " + listenerId + ");" + JAXXCompiler.getLineSeparator(), "removePropertyChangeListener(\"" + memberName + "\", " + listenerId + ");" + JAXXCompiler.getLineSeparator());
                                contextClass = newField.getType();
                                assert (contextClass != null) : "script field '" + memberName + "' is defined, but has type null";
                                currentSymbol.setLength(0);
                                accepted = true;
                                recognizeClassNames = false;
                                break;
                            }
                        }
                    }
                }
            }
            if (currentSymbol.length() > 0 && recognizeClassNames && (contextClass = TagManager.resolveClass(currentSymbol.toString(), this.compiler)) != null) {
                currentSymbol.setLength(0);
                return null;
            }
            if (accepted) continue;
            return null;
        }
        return contextClass;
    }

    private ClassDescriptor determineExpressionType(SimpleNode expression, String listenerId) {
        assert (expression.getId() == 62);
        SimpleNode prefix = expression.getChild(0);
        if (prefix.jjtGetNumChildren() == 1) {
            int type = prefix.getChild(0).getId();
            if (type == 66 || type == 39) {
                prefix.setJavaType(prefix.getChild(0).getJavaType());
            } else if (type == 37 && expression.jjtGetNumChildren() == 1) {
                prefix.setJavaType(this.scanCompoundSymbol(prefix.getText().trim(), this.compiler.getRootObject().getObjectClass(), false, listenerId));
            }
        }
        if (expression.jjtGetNumChildren() == 1) {
            return prefix.getJavaType();
        }
        ClassDescriptor contextClass = prefix.getJavaType();
        if (contextClass == null) {
            contextClass = this.compiler.getRootObject().getObjectClass();
        }
        String lastNode = prefix.getText().trim();
        for (int i = 1; i < expression.jjtGetNumChildren(); ++i) {
            SimpleNode suffix;
            block18: {
                suffix = expression.getChild(i);
                if (suffix.jjtGetNumChildren() == 1 && suffix.getChild(0).getId() == 69 && suffix.getChild(0).jjtGetNumChildren() == 0) {
                    if ((contextClass = this.scanCompoundSymbol(lastNode, contextClass, true, listenerId)) == null) {
                        return null;
                    }
                    int dotPos = lastNode.lastIndexOf(".");
                    String objectCode = dotPos == -1 ? "" : lastNode.substring(0, dotPos);
                    for (int j = i - 2; j >= 0; --j) {
                        objectCode = expression.getChild(j).getText() + objectCode;
                    }
                    if (objectCode.length() == 0) {
                        objectCode = this.compiler.getRootObject().getJavaCode();
                    }
                    String methodName = lastNode.substring(dotPos + 1).trim();
                    try {
                        MethodDescriptor method = contextClass.getMethodDescriptor(methodName, new ClassDescriptor[0]);
                        this.trackMemberIfPossible(objectCode, contextClass, method.getName(), true, listenerId);
                        return method.getReturnType();
                    }
                    catch (NoSuchMethodException e) {
                        MethodDescriptor[] newMethods;
                        String propertyName = null;
                        if (methodName.startsWith("is")) {
                            propertyName = Introspector.decapitalize(methodName.substring("is".length()));
                        } else if (methodName.startsWith("get")) {
                            propertyName = Introspector.decapitalize(methodName.substring("get".length()));
                        }
                        if (propertyName == null) break block18;
                        for (MethodDescriptor newMethod : newMethods = this.compiler.getScriptMethods()) {
                            if (!newMethod.getName().equals(methodName)) continue;
                            this.addListener(this.compiler.getRootObject().getId(), null, "addPropertyChangeListener(\"" + propertyName + "\", " + listenerId + ");" + JAXXCompiler.getLineSeparator(), "removePropertyChangeListener(\"" + propertyName + "\", " + listenerId + ");" + JAXXCompiler.getLineSeparator());
                            contextClass = newMethod.getReturnType();
                            break;
                        }
                    }
                }
            }
            if (!(lastNode = suffix.getText().trim()).startsWith(".")) continue;
            lastNode = lastNode.substring(1);
        }
        return null;
    }

    private void trackMemberIfPossible(String objectCode, ClassDescriptor objectClass, String memberName, boolean method, String listenerId) {
        if (objectClass.isInterface()) {
            return;
        }
        DefaultObjectHandler handler = TagManager.getTagHandler(objectClass);
        try {
            if (handler.isMemberBound(memberName)) {
                this.addListener(objectCode + "." + memberName + (method ? "()" : ""), objectCode, handler.getAddMemberListenerCode(objectCode, this.id, memberName, listenerId, this.compiler), handler.getRemoveMemberListenerCode(objectCode, this.id, memberName, listenerId, this.compiler));
            }
        }
        catch (UnsupportedAttributeException e) {
            // empty catch block
        }
    }

    private void determineNodeType(SimpleNode node, String listenerId) {
        ClassDescriptor type = null;
        if (node.jjtGetNumChildren() == 1) {
            type = node.getChild(0).getJavaType();
        }
        switch (node.getId()) {
            case 31: {
                type = ClassDescriptorLoader.getClassDescriptor(Class.class);
                break;
            }
            case 62: {
                type = this.determineExpressionType(node, listenerId);
                break;
            }
            case 66: {
                type = this.determineLiteralType(node);
                break;
            }
            case 61: {
                type = TagManager.resolveClass(node.getChild(0).getText(), this.compiler);
            }
        }
        node.setJavaType(type);
    }

    private void addListener(String dependencySymbol, String objectCode, String addCode, String removeCode) {
        this.objectCode = objectCode;
        if (!this.dependencySymbols.contains(dependencySymbol)) {
            this.dependencySymbols.add(dependencySymbol);
            if (objectCode != null) {
                this.addListenerCode.append("if (").append(objectCode).append(" != null) {").append(JAXXCompiler.getLineSeparator());
                this.addListenerCode.append("    ");
            }
            this.addListenerCode.append("    ").append(addCode);
            if (objectCode != null) {
                this.addListenerCode.append("    ").append("}");
            }
            if (objectCode != null) {
                this.removeListenerCode.append("if (").append(objectCode).append(" != null) {").append(JAXXCompiler.getLineSeparator());
                this.removeListenerCode.append("    ");
            }
            this.removeListenerCode.append("    ").append(removeCode);
            if (objectCode != null) {
                this.removeListenerCode.append("    }");
            }
        }
    }

    private void compileListeners() {
        String javaCodeId = TypeManager.getJavaCode(this.id);
        if (this.addListenerCode.length() > 0) {
            if (this.compiler.haveApplyDataBinding()) {
                this.compiler.appendApplyDataBinding(" else ");
            }
            this.compiler.appendApplyDataBinding("if (" + javaCodeId + ".equals($binding)) {" + JAXXCompiler.getLineSeparator());
            this.compiler.appendApplyDataBinding("    " + this.addListenerCode + JAXXCompiler.getLineSeparator());
            this.compiler.appendApplyDataBinding("}");
        }
        if (this.removeListenerCode.length() > 0) {
            if (this.compiler.haveRemoveDataBinding()) {
                this.compiler.appendRemoveDataBinding(" else ");
            }
            this.compiler.appendRemoveDataBinding("if (" + javaCodeId + ".equals($binding)) {" + JAXXCompiler.getLineSeparator());
            this.compiler.appendRemoveDataBinding("    " + this.removeListenerCode + JAXXCompiler.getLineSeparator());
            this.compiler.appendRemoveDataBinding("}");
        }
    }

    private class NULL {
        private NULL() {
        }
    }
}

