package org.nuiton.jaxx.application.swing;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.jaxx.application.ApplicationContext;
import org.nuiton.jaxx.application.swing.action.ApplicationActionEngine;
import org.nuiton.jaxx.application.swing.action.ApplicationActionFactory;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.swing.util.ApplicationErrorHelper;

import java.awt.Color;
import java.awt.Component;

/**
 * Created on 11/24/13.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public interface ApplicationUIContext extends ApplicationContext {

    /**
     * @return the main ui of the application.
     */
    Component getMainUI();

    /**
     * @return the ui used to display long action.
     */
    ApplicationActionUI getActionUI();

    /**
     * Wait until the action ui is not null and then returns it.
     *
     * @return the ui used to display long action.
     */
    ApplicationActionUI getExistingActionUI();

    Component getBodyUI();

    Component getStatusUI();

    boolean isBusy();

    void setBusy(boolean busy);

    boolean isHideBody();

    void setHideBody(boolean b);

    Color getColorBlockingLayer();

    ApplicationActionFactory getActionFactory();

    ApplicationActionEngine getActionEngine();

    ApplicationErrorHelper getErrorHelper();

    String getI18nPrefix();

    String getDateFormat();
}
