/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class BundleValidation {
    protected ImmutableSortedSet<Locale> locales;
    protected Map<Locale, SortedSet<String>> keysMissingValues = new HashMap<Locale, SortedSet<String>>();
    protected SortedSetMultimap<Locale, String> keysPerLocale;
    protected Ordering<Locale> localeOrdering;

    public BundleValidation(Locale[] locales) {
        List<Locale> localesList = Arrays.asList(locales);
        this.localeOrdering = Ordering.explicit(localesList);
        this.locales = ImmutableSortedSet.orderedBy(this.localeOrdering).addAll(localesList).build();
        this.keysPerLocale = this.newEmptyMapForBundles();
    }

    public Map<Locale, SortedSet<String>> getKeysMissingValues() {
        return this.keysMissingValues;
    }

    public SortedSetMultimap<Locale, String> getKeysPerLocale() {
        return this.keysPerLocale;
    }

    public SortedSetMultimap<Locale, String> getMissingKeysPerLocale() {
        ImmutableSortedSet allKeysFromAllBundles = ImmutableSortedSet.copyOf((Collection)this.keysPerLocale.values());
        SortedSetMultimap<Locale, String> missingKeysPerLocale = this.newEmptyMapForBundles();
        for (Locale locale : this.locales) {
            SortedSet keysInBundle = this.keysPerLocale.get((Object)locale);
            Sets.SetView missingKeysInBundle = Sets.symmetricDifference((Set)allKeysFromAllBundles, (Set)keysInBundle);
            missingKeysPerLocale.putAll((Object)locale, (Iterable)missingKeysInBundle);
        }
        return missingKeysPerLocale;
    }

    public boolean isAnyKeyMissingInBundle() {
        return !this.getMissingKeysPerLocale().isEmpty();
    }

    public boolean isAnyKeyMissingValue() {
        return !this.getKeysMissingValues().isEmpty();
    }

    public boolean isFail() {
        return this.isAnyKeyMissingValue() || this.isAnyKeyMissingInBundle();
    }

    protected SortedSetMultimap<Locale, String> newEmptyMapForBundles() {
        return TreeMultimap.create(this.localeOrdering, (Comparator)Ordering.natural());
    }
}

