/*
 * #%L
 * I18n :: Maven Plugin
 * 
 * $Id: AvailableConverterMojo.java 1961 2012-07-09 13:12:35Z tchemit $
 * $HeadURL: https://nuiton.org/svn/i18n/tags/i18n-3.0/i18n-maven-plugin/src/main/java/org/nuiton/i18n/plugin/bundle/AvailableConverterMojo.java $
 * %%
 * Copyright (C) 2007 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.i18n.plugin.bundle;

import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.plugin.AbstractAvailableDataMojo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

/**
 * Mojo used to display available {@link BundleFormatConverter}.
 * <p/>
 * Created: 09/05/11
 *
 * @author fdesbois <desbois@codelutin.com>
 *         $Id: AvailableConverterMojo.java 1961 2012-07-09 13:12:35Z tchemit $
 * @since 2.4
 */
@Mojo(name = "available-converters",
      requiresProject = true,
      requiresDirectInvocation = true,
      requiresDependencyResolution = ResolutionScope.TEST)
public class AvailableConverterMojo extends AbstractAvailableDataMojo {

    /**
     * Map of all availables {@link BundleFormatConverter}.
     *
     * @since 2.4
     */
    @Component(role = BundleFormatConverter.class)
    protected Map<String, BundleFormatConverter> bundleFormatConverters;

    @Override
    protected Collection<AvailableData> getAllAvailableDatas() {

        AvailableData data = new AvailableData() {

            @Override
            public String name() {
                return "bundleFormatConverter";
            }

            @Override
            public Map<String, ?> getData() {
                return bundleFormatConverters;
            }

            @Override
            public String toString(Object value) {
                return value.getClass().getName();
            }
        };

        return Arrays.asList(data);
    }

}
