/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.helper.plugin;

import java.util.Properties;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.plugin.AbstractPlugin;

@Mojo(name="compute-distribution-site-url", defaultPhase=LifecyclePhase.VALIDATE, requiresOnline=true, requiresProject=true)
public class ComputeDistributionSiteUrlMojo
extends AbstractPlugin {
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="helper.distributionSiteUrlPrefix", defaultValue="scpexe://forge.nuiton.org/var/lib/doc/maven-site/${platform}/${projectId}", required=true)
    private String distributionSiteUrlPrefix;
    @Parameter(property="helper.snapshotSiteDeployClassifier", defaultValue="develop", required=true)
    private String snapshotSiteDeployClassifier;
    @Parameter(property="helper.releaseSiteDeployClassifier", defaultValue="${project.version}", required=true)
    private String releaseSiteDeployClassifier;
    @Parameter(property="helper.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(property="helper.runOnce", defaultValue="true")
    private boolean runOnce;
    private String siteDeployClassifier;
    private String distributionSiteUrl;

    public boolean checkSkip() {
        boolean result = true;
        if (this.runOnce) {
            String key = "compute-distribution-site-url##" + this.project.getVersion();
            boolean shouldInvoke = this.needInvoke(true, false, key);
            result = shouldInvoke && super.checkSkip();
        }
        return result;
    }

    protected void init() throws Exception {
        if (this.project.getVersion().endsWith(SNAPSHOT_SUFFIX)) {
            this.siteDeployClassifier = this.snapshotSiteDeployClassifier;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Use snapshot siteDeployClassifier: " + this.siteDeployClassifier));
            }
        } else {
            this.siteDeployClassifier = this.releaseSiteDeployClassifier;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Use release siteDeployClassifier: " + this.siteDeployClassifier));
            }
        }
        this.distributionSiteUrl = this.distributionSiteUrlPrefix.trim();
        if (!this.distributionSiteUrl.endsWith("/")) {
            this.distributionSiteUrl = this.distributionSiteUrl + "/";
        }
        this.distributionSiteUrl = this.distributionSiteUrl + this.siteDeployClassifier;
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Use release distributionSiteUrl: " + this.distributionSiteUrl));
        }
    }

    protected void doAction() throws Exception {
        Properties properties = this.project.getProperties();
        this.getLog().info((CharSequence)("export siteDeployClassifier [" + this.siteDeployClassifier + "]"));
        this.project.getDistributionManagement().getSite().setUrl(this.distributionSiteUrl);
        properties.setProperty("siteDeployClassifier", this.siteDeployClassifier);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

