/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.helper.plugin;

import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.nuiton.plugin.AbstractPlugin;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

@Mojo(name="share-server-secret", defaultPhase=LifecyclePhase.INITIALIZE, requiresProject=true)
public class ShareServerSecretPlugin
extends AbstractPlugin {
    @Component
    protected MavenProject project;
    @Component
    protected Settings settings;
    @Parameter(property="helper.serverId", required=true)
    protected String serverId;
    @Parameter
    protected String usernameOut;
    @Parameter
    protected String passwordOut;
    @Parameter
    protected String passphraseOut;
    @Parameter
    protected String privateKeyOut;
    @Parameter(property="helper.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="helper.runOnce", defaultValue="true")
    protected boolean runOnce;
    @Parameter(property="helper.skipNullValues", defaultValue="false")
    protected boolean skipNullValues;
    @Component(hint="maven-helper-plugin")
    protected SecDispatcher sec;
    private Server server;
    private Map<Property, String> propertiesToTreate;

    public void init() throws Exception {
        this.propertiesToTreate = new EnumMap<Property, String>(Property.class);
        if (StringUtils.isNotEmpty((CharSequence)this.usernameOut)) {
            this.propertiesToTreate.put(Property.username, this.usernameOut);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.passwordOut)) {
            this.propertiesToTreate.put(Property.password, this.passwordOut);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.passphraseOut)) {
            this.propertiesToTreate.put(Property.passphrase, this.passphraseOut);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.privateKeyOut)) {
            this.propertiesToTreate.put(Property.privateKey, this.privateKeyOut);
        }
        if (this.propertiesToTreate.isEmpty()) {
            throw new MojoExecutionException("Nothing to export, you should specify what to export via 'usernameOut', 'passwordOut', 'passphraseOut' or 'privateKeyOut' parameters.");
        }
        if (StringUtils.isEmpty((CharSequence)this.serverId)) {
            throw new MojoExecutionException("No 'serverId' defined.");
        }
        this.server = this.settings.getServer(this.serverId.trim());
        if (this.server == null) {
            throw new MojoExecutionException("Could not find server with id '" + this.serverId + "', check your settings.xml file.");
        }
    }

    public boolean checkSkip() {
        if (this.runOnce) {
            Object value;
            StringBuilder buffer = new StringBuilder("share-secret##");
            buffer.append(this.serverId);
            buffer.append("##");
            for (Map.Entry<Property, String> entry : this.propertiesToTreate.entrySet()) {
                buffer.append((Object)entry.getKey()).append(entry.getValue());
            }
            String key = buffer.toString();
            if (this.verbose) {
                this.getLog().info((CharSequence)("check if already done for key : " + key));
            }
            if ((value = this.project.getProperties().get(key)) != null) {
                this.getLog().info((CharSequence)"Goal was already executed, will skip goal.");
                return false;
            }
            long timestamp = System.nanoTime();
            this.project.getProperties().put(key, timestamp + "");
            if (this.verbose) {
                this.getLog().info((CharSequence)("Adding cache key " + key + " with timestamp " + timestamp));
            }
        }
        return true;
    }

    protected void doAction() throws Exception {
        Properties properties = this.project.getModel().getProperties();
        for (Map.Entry<Property, String> entry : this.propertiesToTreate.entrySet()) {
            Property key = entry.getKey();
            String propertyValue = key.getSecret(this.server);
            String propertyTargetName = entry.getValue();
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("will decrypt [" + (Object)((Object)key) + "] : " + propertyValue));
            }
            if ((propertyValue = this.sec.decrypt(propertyValue)) == null) {
                if (this.skipNullValues) {
                    this.getLog().warn((CharSequence)("no export server [" + this.serverId + "] " + key.name() + " in ${" + propertyTargetName + "} (null value)"));
                    continue;
                }
                throw new MojoExecutionException("Null values found for server [" + this.serverId + "] " + key.name() + ", use skipNullValue to authrize it.");
            }
            this.getLog().info((CharSequence)("export server [" + this.serverId + "] " + key.name() + " in ${" + propertyTargetName + "}"));
            properties.setProperty(propertyTargetName, propertyValue);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getPassphraseOut() {
        return this.passphraseOut;
    }

    public void setPassphraseOut(String passphraseOut) {
        this.passphraseOut = passphraseOut;
    }

    public String getPasswordOut() {
        return this.passwordOut;
    }

    public void setPasswordOut(String passwordOut) {
        this.passwordOut = passwordOut;
    }

    public String getPrivateKeyOut() {
        return this.privateKeyOut;
    }

    public void setPrivateKeyOut(String privateKeyOut) {
        this.privateKeyOut = privateKeyOut;
    }

    public String getUsernameOut() {
        return this.usernameOut;
    }

    public void setUsernameOut(String usernameOut) {
        this.usernameOut = usernameOut;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setSec(SecDispatcher sec) {
        this.sec = sec;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setRunOnce(boolean runOnce) {
        this.runOnce = runOnce;
    }

    public static enum Property {
        username{

            @Override
            public String getSecret(Server server) {
                return server.getUsername();
            }
        }
        ,
        password{

            @Override
            public String getSecret(Server server) {
                return server.getPassword();
            }
        }
        ,
        passphrase{

            @Override
            public String getSecret(Server server) {
                return server.getPassphrase();
            }
        }
        ,
        privateKey{

            @Override
            public String getSecret(Server server) {
                return server.getPrivateKey();
            }
        };


        public abstract String getSecret(Server var1);
    }
}

