/*
 * #%L
 * Maven helper plugin
 * 
 * $Id: RestClientConfiguration.java 814 2011-05-10 22:07:16Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/helper-maven-plugin-1.4/src/main/java/org/nuiton/io/rest/RestClientConfiguration.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.io.rest;

import java.net.URL;

/**
 * Contract of a {@link RestClient}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.3
 */
public interface RestClientConfiguration {

    /** @return base url of server */
    URL getRestUrl();

    /** @return the encoding used to encode request to send */
    String getEncoding();

    /** @return the username to connect to server */
    String getRestUsername();

    /** @return the password to connect to server */
    String getRestPassword();

    /** @return {@code true} to make verbose client (show request and parameters) */
    boolean isVerbose();

    /** @return {@code true} if rest client does not need login */
    boolean isAnonymous();

    /** @param restUrl the url of server to set */
    void setRestUrl(URL restUrl);

    /** @param restPassword the password to connect to server to set */
    void setRestPassword(String restPassword);

    /** @param restUsername the username to connect to server to set */
    void setRestUsername(String restUsername);

    /** @param encoding the encodng used to encode request to set */
    void setEncoding(String encoding);

    /** @param verbose the flag verbose to set */
    void setVerbose(boolean verbose);

    /** @param anonymous the flag anonymous to set */
    void setAnonymous(boolean anonymous);
}
