/*
 * #%L
 * EUGene :: Maven plugin
 * 
 * $Id: BaseChainedFileWriter.java 863 2010-04-15 14:22:49Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/eugene/tags/eugene-2.0.1/maven-eugene-plugin/src/main/java/org/nuiton/eugene/plugin/writer/BaseChainedFileWriter.java $
 * %%
 * Copyright (C) 2006 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.eugene.plugin.writer;

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.state.StateModel;
import org.nuiton.eugene.writer.AbstractChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;

import java.util.Map;
import java.util.Set;

/**
 * Surcharge de l'implentation abstraite pour avoir le logger de la console
 * maven.
 *
 * @author tchemit
 * @since 2.0.0
 */
public abstract class BaseChainedFileWriter extends AbstractChainedFileWriter {

    /**
     * Logger
     */
    private Log log;

    protected BaseChainedFileWriter(String... propertyNameAndDescriptions) {
        super(propertyNameAndDescriptions);
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (log == null) {
            log = new SystemStreamLog();
        }

        return log;
    }

    @Override
    protected void initWriter(ChainedFileWriterConfiguration configuration) {
        super.initWriter(configuration);

        // log writer config

        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<String, String>> set =
                getAuthorizedPropertyDescriptions().entrySet();
        if (set.isEmpty()) {
            buffer.append("Writer [");
            buffer.append(getInputProtocol());
            buffer.append("]");
            buffer.append(" does not use any specific properties.");
        } else {
            buffer.append("Writer [");
            buffer.append(getInputProtocol());
            buffer.append("]");
            buffer.append(" use ");
            buffer.append(properties.size());
            buffer.append(" properties :");
            if (getLog().isInfoEnabled()) {
                for (Map.Entry<String, String> e : set) {

                    String key = e.getKey();
                    Object value = properties.get(key);
                    if (value != null) {
                        buffer.append("\n");
                        buffer.append("  [");
                        buffer.append(key);
                        buffer.append("] (");
                        buffer.append(e.getValue());
                        buffer.append(") : ");
                        buffer.append(value);
                    }
                }
            }
        }
        getLog().info(buffer.toString());
    }

    protected boolean acceptObjectModelOrStateModel(String modelType) {
        modelType = modelType.trim().toLowerCase();
        return ObjectModel.NAME.equals(modelType) ||
               StateModel.NAME.equals(modelType);
    }


}
