/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.awt.Color;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.KeyStroke;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.misc.NotNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.nuiton.eugene.DefaultTemplateConfiguration;
import org.nuiton.eugene.TemplateConfiguration;
import org.nuiton.eugene.config.templates.ApplicationConfigTransformer;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelClassImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.nuiton.eugene.plugin.parser.java.Java8BaseVisitor;
import org.nuiton.eugene.plugin.parser.java.Java8Lexer;
import org.nuiton.eugene.plugin.parser.java.Java8Parser;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginWithEncoding;
import org.nuiton.version.Version;

@Mojo(name="generate-config", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateApplicationConfigMojo
extends AbstractPlugin
implements PluginWithEncoding {
    @Parameter(property="eugene.packageName")
    private String packageName;
    @Parameter(property="eugene.modelName", required=true)
    private String modelName;
    @Parameter(property="eugene.optionsClassName")
    private String optionsClassName;
    @Parameter(property="eugene.actionsClassName")
    private String actionsClassName;
    @Parameter(property="eugene.sourceDirectory", defaultValue="${basedir}/src/main/java", required=true)
    private File sourceDirectory;
    @Parameter(property="eugene.outputdirectory", defaultValue="${basedir}/target/generated-sources/java", required=true)
    private File outputdirectory;
    @Parameter(property="eugene.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="eugene.encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="eugene.prefix", defaultValue="Config")
    protected String prefix;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    protected ObjectModelImpl model;
    protected ApplicationConfigTransformer template;

    protected void init() throws Exception {
        File javaFile;
        File file;
        if (this.packageName == null) {
            this.packageName = this.getProject().getGroupId() + "." + this.getProject().getArtifactId().replaceAll("-", ".");
            this.getLog().info((CharSequence)("Use package name: " + this.packageName));
        }
        if (this.optionsClassName == null) {
            this.optionsClassName = this.packageName + "." + this.modelName + this.prefix + "Option";
            file = PluginHelper.getFile((File)this.sourceDirectory, (String[])this.optionsClassName.split("\\."));
            javaFile = new File(file.getParentFile(), file.getName() + ".java");
            if (!javaFile.exists()) {
                this.prefix = "Configuration";
                this.optionsClassName = this.packageName + "." + this.modelName + this.prefix + "Option";
                file = PluginHelper.getFile((File)this.sourceDirectory, (String[])this.optionsClassName.split("\\."));
                javaFile = new File(file.getParentFile(), file.getName() + ".java");
                if (!javaFile.exists()) {
                    throw new MojoExecutionException("Can't find option file at: " + javaFile);
                }
            }
            this.getLog().info((CharSequence)("Detected configuration options class: " + this.optionsClassName));
        }
        if (this.actionsClassName == null) {
            this.actionsClassName = this.packageName + "." + this.modelName + this.prefix + "Action";
            file = PluginHelper.getFile((File)this.sourceDirectory, (String[])this.actionsClassName.split("\\."));
            javaFile = new File(file.getParentFile(), file.getName() + ".java");
            if (javaFile.exists()) {
                this.getLog().info((CharSequence)("Detected configuration actions class: " + this.actionsClassName));
            } else {
                this.actionsClassName = null;
            }
        }
        URLClassLoader loader = this.initClassLoader(this.getProject(), this.sourceDirectory, true, false, false, true, true);
        this.model = new ObjectModelImpl();
        this.model.setName(this.modelName);
        String className = this.modelName + this.prefix;
        this.getLog().info((CharSequence)("Config class name: " + className));
        File file2 = PluginHelper.getFile((File)this.sourceDirectory, (String[])this.optionsClassName.split("\\."));
        File javaFile2 = new File(file2.getParentFile(), file2.getName() + ".java");
        String content = FileUtils.readFileToString((File)javaFile2, (String)this.encoding);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)new Java8Lexer((CharStream)new ANTLRInputStream(content)));
        Java8Parser parser = new Java8Parser((TokenStream)tokenStream);
        ((ParserATNSimulator)parser.getInterpreter()).enable_global_context_dfa = true;
        JavaParserVisitor visitor = new JavaParserVisitor(loader, javaFile2);
        parser.compilationUnit().accept(visitor);
        Map<String, String> names = visitor.getNames();
        ObjectModelClassImpl aClass = new ObjectModelClassImpl();
        aClass.setName(className);
        aClass.setPackage(this.packageName);
        this.model.addClass(aClass);
        for (Map.Entry<String, String> entry : names.entrySet()) {
            ObjectModelAttributeImpl attribute = new ObjectModelAttributeImpl();
            attribute.setName(JavaGeneratorUtil.convertConstantNameToVariableName((String)entry.getKey()));
            attribute.setType(entry.getValue());
            aClass.addAttribute(attribute);
        }
        Properties templateProperties = new Properties();
        templateProperties.put("encoding", this.getEncoding());
        templateProperties.put("verbose", (Object)this.verbose);
        templateProperties.put("overwrite", (Object)true);
        templateProperties.put("classLoader", loader);
        templateProperties.put("optionClassName", this.optionsClassName);
        if (this.actionsClassName != null) {
            templateProperties.put("actionClassName", this.actionsClassName);
        }
        this.template = new ApplicationConfigTransformer();
        this.template.setConfiguration((TemplateConfiguration)new DefaultTemplateConfiguration(templateProperties));
        if (!this.project.getCompileSourceRoots().contains(this.outputdirectory.getPath())) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Add compile source root : " + this.outputdirectory));
            }
            this.project.addCompileSourceRoot(this.outputdirectory.getPath());
        }
    }

    protected void doAction() throws Exception {
        this.getLog().info((CharSequence)("Generate file(s) to: " + this.outputdirectory));
        this.template.applyTemplate((Model)this.model, this.outputdirectory);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    protected class JavaParserVisitor
    extends Java8BaseVisitor<Void> {
        protected final Map<String, String> names;
        private final ClassLoader loader;
        protected final File file;
        String name;
        boolean first;

        private JavaParserVisitor(ClassLoader loader, File file) {
            this.loader = loader;
            this.file = file;
            this.names = new LinkedHashMap<String, String>();
        }

        public Map<String, String> getNames() {
            return this.names;
        }

        @Override
        public Void visitEnumConstant(Java8Parser.EnumConstantContext ctx) {
            this.name = ctx.getChild(0).getText();
            this.first = false;
            return (Void)super.visitEnumConstant(ctx);
        }

        @Override
        public Void visitArgumentList(@NotNull Java8Parser.ArgumentListContext ctx) {
            if (!this.first) {
                String type;
                switch (type = StringUtils.removeEnd((String)ctx.getChild(0).getText(), (String)".class")) {
                    case "File": {
                        type = File.class.getName();
                        break;
                    }
                    case "Color": {
                        type = Color.class.getName();
                        break;
                    }
                    case "KeyStroke": {
                        type = KeyStroke.class.getName();
                        break;
                    }
                    case "URL": {
                        type = URL.class.getName();
                        break;
                    }
                    case "Class": {
                        type = Class.class.getName();
                        break;
                    }
                    case "Date": {
                        type = Date.class.getName();
                        break;
                    }
                    case "Time": {
                        type = Time.class.getName();
                        break;
                    }
                    case "Timestamp": {
                        type = Timestamp.class.getName();
                        break;
                    }
                    case "Locale": {
                        type = Locale.class.getName();
                        break;
                    }
                    case "Version": {
                        type = Version.class.getName();
                        break;
                    }
                    case "String": 
                    case "int": 
                    case "Integer": 
                    case "long": 
                    case "Long": 
                    case "float": 
                    case "Float": 
                    case "boolean": 
                    case "Boolean": 
                    case "byte": 
                    case "Byte": 
                    case "char": 
                    case "Character": 
                    case "double": 
                    case "Double": {
                        break;
                    }
                    default: {
                        try {
                            this.loader.loadClass(type);
                            break;
                        }
                        catch (ClassNotFoundException e) {
                            File sourceFile = PluginHelper.getFile((File)GenerateApplicationConfigMojo.this.sourceDirectory, (String[])type.split("\\."));
                            sourceFile = new File(sourceFile.getParentFile(), sourceFile.getName() + ".java");
                            if (sourceFile.exists()) break;
                            throw new IllegalStateException("Can't find real type of " + type + " for option: " + this.name + ", please use the fully qualified name in code");
                        }
                    }
                }
                this.names.put(this.name, type);
                this.first = true;
            }
            return (Void)super.visitArgumentList(ctx);
        }
    }
}

