/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.modelextension;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.nuiton.eugene.models.stereotype.StereotypeAble;
import org.nuiton.eugene.models.tagvalue.TagValueAble;

public class ElementBean
implements Comparable<ElementBean> {
    protected final String name;
    protected final Map<String, String> tagValues;
    protected final Set<String> stereotypes;

    public ElementBean(String name) {
        this.name = name;
        this.tagValues = new TreeMap<String, String>();
        this.stereotypes = new TreeSet<String>();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTagValues() {
        return this.tagValues;
    }

    public Set<String> getStereotypes() {
        return this.stereotypes;
    }

    @Override
    public int compareTo(ElementBean o) {
        return this.name.compareTo(o.name);
    }

    public <T extends TagValueAble & StereotypeAble> void load(T tag) {
        this.tagValues.putAll(tag.getTagValues());
        this.stereotypes.addAll(((StereotypeAble)tag).getStereotypes());
    }
}

