/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.AbstractJavaBeanTransformer;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.JavaTemplatesStereoTypes;
import org.nuiton.eugene.java.JavaTemplatesTagValues;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class SimpleJavaBeanWithNoInterfaceTransformer
extends AbstractJavaBeanTransformer {
    private static final Log log = LogFactory.getLog(SimpleJavaBeanWithNoInterfaceTransformer.class);
    ImmutableMap<ObjectModelClass, String> beanNameTranslation;
    ImmutableMap<ObjectModelClass, String> beanDefaultsNameTranslation;
    ImmutableSet<ObjectModelClass> beanClasses;
    ImmutableSet<ObjectModelClass> beanDefaultClasses;

    public void transformFromModel(ObjectModel model) {
        boolean generateInitializerRunnerClassName;
        boolean generateModelInitializer;
        super.transformFromModel(model);
        ImmutableMap.Builder beanNameTranslationBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder beanDefaultsNameTranslationBuilder = new ImmutableMap.Builder();
        ImmutableSet.Builder beanClassesBuilder = new ImmutableSet.Builder();
        ImmutableSet.Builder beanDefaultClassesBuilder = new ImmutableSet.Builder();
        JavaTemplatesTagValues javaTemplatesTagValues = this.getJavaTemplatesTagValues();
        JavaTemplatesStereoTypes javaTemplatesStereoTypes = this.getJavaTemplatesStereoTypes();
        for (ObjectModelClass aClass : model.getClasses()) {
            ObjectModelPackage aPackage;
            if (!JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)aClass, aPackage = model.getPackage(aClass.getPackageName()))) continue;
            beanClassesBuilder.add((Object)aClass);
            String classNamePrefix = javaTemplatesTagValues.getSimpleBeanWithNoInterfaceClassNamePrefixTagValue((ObjectModelClassifier)aClass, aPackage, model);
            String classNameSuffix = javaTemplatesTagValues.getSimpleBeanWithNoInterfaceClassNameSuffixTagValue((ObjectModelClassifier)aClass, aPackage, model);
            String generateName = this.generateName(classNamePrefix, aClass.getName(), classNameSuffix);
            beanNameTranslationBuilder.put((Object)aClass, (Object)generateName);
            boolean canGenerateDefaults = !javaTemplatesStereoTypes.isSimpleBeanWithNoInterfaceSkipGenerateDefaults((ObjectModelClassifier)aClass, aPackage, model);
            if (!canGenerateDefaults) continue;
            beanDefaultClassesBuilder.add((Object)aClass);
            String classDefaultsNamePrefix = javaTemplatesTagValues.getSimpleBeanWithNoInterfaceDefaultsClassNamePrefixTagValue((ObjectModelClassifier)aClass, aPackage, model);
            String classDefaultsNameSuffix = javaTemplatesTagValues.getSimpleBeanWithNoInterfaceDefaultsClassNameSuffixTagValue((ObjectModelClassifier)aClass, aPackage, model);
            String generateDefaultsName = this.generateName(classDefaultsNamePrefix, aClass.getName(), classDefaultsNameSuffix);
            beanDefaultsNameTranslationBuilder.put((Object)aClass, (Object)generateDefaultsName);
        }
        this.beanClasses = beanClassesBuilder.build();
        this.beanDefaultClasses = beanDefaultClassesBuilder.build();
        this.beanNameTranslation = beanNameTranslationBuilder.build();
        this.beanDefaultsNameTranslation = beanDefaultsNameTranslationBuilder.build();
        ImmutableMap beanClassesByFqn = Maps.uniqueIndex(this.beanClasses, (Function)new Function<ObjectModelClass, String>(){

            public String apply(ObjectModelClass input) {
                return input.getQualifiedName();
            }
        });
        ArrayList beanClassesFqn = new ArrayList(beanClassesByFqn.keySet());
        Collections.sort(beanClassesFqn);
        String defaultPackageName = this.getDefaultPackageName();
        String modelBeanInitializeClassName = model.getName() + "ModelInitializer";
        boolean bl = generateModelInitializer = !this.isInClassPath(defaultPackageName + "." + modelBeanInitializeClassName);
        if (generateModelInitializer) {
            ObjectModelInterface anInterface = this.createInterface(modelBeanInitializeClassName, defaultPackageName);
            this.addOperation((ObjectModelClassifier)anInterface, "start", "void", new ObjectModelModifier[0]);
            this.addOperation((ObjectModelClassifier)anInterface, "end", "void", new ObjectModelModifier[0]);
            for (String fqn : beanClassesFqn) {
                ObjectModelClass beanClass = (ObjectModelClass)beanClassesByFqn.get((Object)fqn);
                String beanName = (String)this.beanNameTranslation.get((Object)beanClass);
                this.addImport((ObjectModelClassifier)anInterface, beanName);
                this.addOperation((ObjectModelClassifier)anInterface, "init" + (String)beanName, "void", new ObjectModelModifier[0]);
            }
        }
        String modelInitializerRunnerClassName = model.getName() + "ModelInitializerRunner";
        boolean bl2 = generateInitializerRunnerClassName = !this.isInClassPath(defaultPackageName + "." + modelInitializerRunnerClassName);
        if (generateInitializerRunnerClassName) {
            ObjectModelClass aClass = this.createClass(modelInitializerRunnerClassName, defaultPackageName);
            StringBuilder bodyBuilder = new StringBuilder();
            bodyBuilder.append("\n        initializer.start();");
            for (String fqn : beanClassesFqn) {
                ObjectModelClass beanClass = (ObjectModelClass)beanClassesByFqn.get((Object)fqn);
                String beanName = (String)this.beanNameTranslation.get((Object)beanClass);
                this.addImport((ObjectModelClassifier)aClass, beanName);
                bodyBuilder.append("\n        initializer.init" + beanName + "();");
            }
            bodyBuilder.append("\n        initializer.end();");
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)aClass, "init", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC});
            this.addParameter(operation, modelBeanInitializeClassName, "initializer");
            this.setOperationBody(operation, bodyBuilder.toString());
        }
    }

    public void transformFromClass(ObjectModelClass input) {
        ObjectModelPackage aPackage = this.getPackage((ObjectModelClassifier)input);
        if (this.beanClasses.contains((Object)input)) {
            boolean generateDefaults;
            boolean generateAbstractClass;
            boolean generateClass;
            String prefix = this.getConstantPrefix((ObjectModelClassifier)input);
            this.setConstantPrefix(prefix);
            String className = (String)this.beanNameTranslation.get((Object)input);
            String abstractClassName = "Abstract" + className;
            boolean bl = generateClass = this.canGenerateClassWithMethods(aPackage, input, className) && this.notFoundInClassPath(input, className);
            if (generateClass) {
                this.generateBeanClass(input, className, abstractClassName);
            }
            if (generateAbstractClass = this.canGenerateAbstractClass(aPackage, input, abstractClassName)) {
                this.generateAbstractBeanClass(aPackage, input, abstractClassName);
            }
            if (generateDefaults = this.beanDefaultClasses.contains((Object)input)) {
                String defaultClassName = (String)this.beanDefaultsNameTranslation.get((Object)input);
                String abstractDefaultClassName = "Abstract" + defaultClassName;
                if (this.notFoundInClassPath(input, defaultClassName)) {
                    this.generateBeanDefaults(input, abstractDefaultClassName, defaultClassName);
                }
                if (this.canGenerateAbstractClass(aPackage, input, abstractDefaultClassName)) {
                    this.generateAbstractBeanDefaults(aPackage, input, className, abstractDefaultClassName);
                }
            }
        }
    }

    protected ObjectModelClass generateBeanClass(ObjectModelClass input, String className, String abstractClassName) {
        ObjectModelClass output = input.isAbstract() ? this.createAbstractClass(className, input.getPackageName()) : this.createClass(className, input.getPackageName());
        this.setSuperClass(output, abstractClassName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        this.addSerializable(input, output, true);
        return output;
    }

    protected ObjectModelClass generateAbstractBeanClass(ObjectModelPackage aPackage, ObjectModelClass input, String className) {
        String superClass = null;
        boolean superClassIsBean = false;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                superClassIsBean = this.beanClasses.contains((Object)superclass);
                if (superClassIsBean) {
                    superClass = superclass.getPackageName() + "." + (String)this.beanNameTranslation.get((Object)superclass);
                    break;
                }
                superClass = superclass.getQualifiedName();
            }
        }
        if (!superClassIsBean && (superClass = this.getJavaTemplatesTagValues().getSimpleBeanWithNoInterfaceSuperClassTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model)) != null) {
            superClassIsBean = true;
        }
        ObjectModelClass output = this.createAbstractClass(className, input.getPackageName());
        if (superClass != null) {
            this.setSuperClass(output, superClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        boolean serializableFound = this.addInterfaces(input, (ObjectModelClassifier)output, null);
        this.generateI18nBlockAndConstants(aPackage, input, (ObjectModelClassifier)output);
        this.addSerializable(input, output, serializableFound || superClassIsBean);
        List<ObjectModelAttribute> properties = this.getProperties(input);
        boolean usePCS = !this.getJavaTemplatesStereoTypes().isSkipGeneratePropertyChangeSupport((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        boolean generateBooleanGetMethods = this.getEugeneTagValues().isGenerateBooleanGetMethods((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        boolean generateNotEmptyCollections = !this.getJavaTemplatesStereoTypes().isSkipGenerateNotEmptyCollections((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        for (ObjectModelAttribute attr : properties) {
            this.createProperty(output, attr, usePCS, generateBooleanGetMethods, generateNotEmptyCollections);
        }
        if (!superClassIsBean) {
            this.addDefaultMethodForNoneBeanSuperClass(output, usePCS, properties);
        }
        return output;
    }

    protected void generateBeanDefaults(ObjectModelClass aClass, String abstractClassName, String defaultClassName) {
        String packageName = aClass.getPackageName();
        ObjectModelClass output = this.createClass(defaultClassName, packageName);
        this.setSuperClass(output, packageName + "." + abstractClassName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
    }

    protected void generateAbstractBeanDefaults(ObjectModelPackage aPackage, ObjectModelClass aClass, String typeName, String abstractClassName) {
        boolean generateFunctions;
        boolean generatePredicates;
        boolean generateContructors;
        ObjectModelClass output = this.createAbstractClass(abstractClassName, aPackage.getName());
        String superClassName = this.getAbstractDefaultsSuperClassName(aPackage, aClass);
        if (StringUtils.isNotBlank((CharSequence)superClassName)) {
            this.setSuperClass(output, superClassName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        this.addImport((ObjectModelClassifier)output, Binder.class);
        this.addImport((ObjectModelClassifier)output, BinderFactory.class);
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "typeOf" + typeName, "<BeanType extends " + typeName + "> Class<BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return (Class<BeanType>) " + typeName + ".class;\n" + "    ");
        boolean bl = generateContructors = !this.getJavaTemplatesStereoTypes().isSimpleBeanWithNoInterfaceSkipGenerateDefaultConstructors((ObjectModelClassifier)aClass, aPackage, (ObjectModel)this.model) && !aClass.isAbstract();
        if (generateContructors) {
            this.generateAbstractBeanDefaultsConstructors(output, typeName);
        }
        this.generateAbstractBeanDefaultsCopyMethods(output, typeName);
        boolean bl2 = generatePredicates = !this.getJavaTemplatesStereoTypes().isSimpleBeanWithNoInterfaceSkipGeneratePredicates((ObjectModelClassifier)aClass, aPackage, (ObjectModel)this.model);
        if (generatePredicates) {
            this.generateAbstractBeanDefaultsPredicates(aClass, output, typeName);
        }
        boolean bl3 = generateFunctions = !this.getJavaTemplatesStereoTypes().isSimpleBeanWithNoInterfaceSkipGenerateFunctions((ObjectModelClassifier)aClass, aPackage, (ObjectModel)this.model);
        if (generateFunctions) {
            this.generateAbstractBeanDefaultsFunctions(aClass, output, typeName);
        }
    }

    protected void generateAbstractBeanDefaultsConstructors(ObjectModelClass output, String typeName) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, typeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return new " + typeName + "();\n" + "    ");
        operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, "<BeanType extends " + typeName + "> BeanType", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "BeanType", "source");
        this.setOperationBody(operation, "\n        Class<BeanType> sourceType = typeOf" + typeName + "();\n" + "        Binder<BeanType, BeanType> binder = BinderFactory.newBinder(sourceType);\n" + "        BeanType result = new" + typeName + "(source, binder);\n" + "        return result;\n" + "    ");
        operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, "<BeanType extends " + typeName + "> BeanType", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "BeanType", "source");
        this.addParameter(operation, "Binder<BeanType, BeanType>", "binder");
        this.setOperationBody(operation, "\n        BeanType result = (BeanType) new" + typeName + "();\n" + "        binder.copy(source, result);\n" + "        return result;\n" + "    ");
    }

    protected void generateAbstractBeanDefaultsCopyMethods(ObjectModelClass output, String typeName) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "copy" + typeName, "<BeanType extends " + typeName + "> void", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "BeanType", "source");
        this.addParameter(operation, "BeanType", "target");
        this.setOperationBody(operation, "\n        Class<BeanType> sourceType = typeOf" + typeName + "();\n" + "        Binder<BeanType, BeanType> binder = BinderFactory.newBinder(sourceType);\n" + "        binder.copy(source, target);\n" + "    ");
        operation = this.addOperation((ObjectModelClassifier)output, "copy" + typeName, "<BeanType extends " + typeName + "> void", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "BeanType", "source");
        this.addParameter(operation, "BeanType", "target");
        this.addParameter(operation, "Binder<BeanType, BeanType>", "binder");
        this.setOperationBody(operation, "\n        binder.copy(source, target);\n    ");
    }

    protected void generateAbstractBeanDefaultsPredicates(ObjectModelClass input, ObjectModelClass output, String typeName) {
        boolean atLeastOnePropertyFound = false;
        for (ObjectModelAttribute attribute : this.getProperties(input)) {
            boolean multiple = JavaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attribute);
            if (multiple) continue;
            atLeastOnePropertyFound = true;
            String attrName = this.getAttributeName(attribute);
            String attrType = this.getAttributeTypeWithGeneric(attribute);
            this.addImport((ObjectModelClassifier)output, attrType);
            String simpleType = JavaGeneratorUtil.getSimpleName((String)attrType);
            String capitalizeAttrName = JavaGeneratorUtil.capitalizeJavaBeanPropertyName((String)attrName);
            String newPreficateMethodName = "new" + capitalizeAttrName + "Predicate";
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, newPreficateMethodName, "<BeanType extends " + typeName + "> Predicate<BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, simpleType, attrName);
            String getterName = this.getGetterName(attribute, attrName);
            this.setOperationBody(operation, "\n        final " + simpleType + " $tmp = " + attrName + ";\n" + "        return new Predicate<BeanType>() {\n" + "\n" + "            @Override\n" + "            public boolean apply(BeanType input) {\n" + "                return Objects.equals($tmp, input." + getterName + "());\n" + "            }\n" + "        };\n" + "\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "filterBy" + capitalizeAttrName, "<BeanType extends " + typeName + "> Iterable<BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "Iterable<BeanType>", "source");
            this.addParameter(operation, simpleType, attrName);
            this.setOperationBody(operation, "\n        return Iterables.filter(source, " + newPreficateMethodName + "(" + attrName + "));\n" + "    ");
        }
        if (atLeastOnePropertyFound) {
            this.addImport((ObjectModelClassifier)output, Predicate.class);
            this.addImport((ObjectModelClassifier)output, Objects.class);
            this.addImport((ObjectModelClassifier)output, Iterable.class);
            this.addImport((ObjectModelClassifier)output, Iterables.class);
        }
    }

    protected void generateAbstractBeanDefaultsFunctions(ObjectModelClass input, ObjectModelClass output, String typeName) {
        boolean atLeastOnePropertyFound = false;
        for (ObjectModelAttribute attribute : this.getProperties(input)) {
            boolean multiple = JavaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attribute);
            if (multiple) continue;
            atLeastOnePropertyFound = true;
            String attrName = this.getAttributeName(attribute);
            String attrType = this.getAttributeTypeWithGeneric(attribute);
            this.addImport((ObjectModelClassifier)output, attrType);
            String simpleType = JavaGeneratorUtil.getSimpleName((String)attrType);
            simpleType = this.wrapPrimitiveType(simpleType);
            String capitalizeAttrName = JavaGeneratorUtil.capitalizeJavaBeanPropertyName((String)attrName);
            String newFunctionMethodName = "new" + capitalizeAttrName + "Function";
            String getFunctionMethodName = "get" + capitalizeAttrName + "Function";
            String functionTypeName = "Function<BeanType, " + simpleType + ">";
            String functionFieldName = JavaGeneratorUtil.convertVariableNameToConstantName((String)(capitalizeAttrName + "Function"));
            this.addAttribute((ObjectModelClassifier)output, functionFieldName, "Function<" + typeName + ", " + simpleType + ">", newFunctionMethodName + "()", new ObjectModelModifier[]{ObjectModelJavaModifier.FINAL, ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PROTECTED});
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, getFunctionMethodName, "<BeanType extends " + typeName + "> " + functionTypeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return (" + functionTypeName + ") " + functionFieldName + ";\n" + "\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, newFunctionMethodName, "<BeanType extends " + typeName + "> " + functionTypeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            String getterName = this.getGetterName(attribute, attrName);
            this.setOperationBody(operation, "\n        return new " + functionTypeName + "() {\n" + "\n" + "            @Override\n" + "            public " + simpleType + " apply(BeanType input) {\n" + "                return input." + getterName + "();\n" + "            }\n" + "        };\n" + "\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "uniqueIndexBy" + capitalizeAttrName, "<BeanType extends " + typeName + "> ImmutableMap<" + simpleType + ", BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "Iterable<BeanType>", "source");
            this.setOperationBody(operation, "\n        return Maps.uniqueIndex(source, " + functionFieldName + ");\n" + "    ");
        }
        if (atLeastOnePropertyFound) {
            this.addImport((ObjectModelClassifier)output, Function.class);
            this.addImport((ObjectModelClassifier)output, Objects.class);
            this.addImport((ObjectModelClassifier)output, ImmutableMap.class);
            this.addImport((ObjectModelClassifier)output, Iterable.class);
            this.addImport((ObjectModelClassifier)output, Maps.class);
        }
    }

    protected String getAbstractDefaultsSuperClassName(ObjectModelPackage aPackage, ObjectModelClass aClass) {
        String superClassName = null;
        boolean superClassIsBean = false;
        Collection superclasses = aClass.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                superClassIsBean = this.beanDefaultClasses.contains((Object)superclass);
                if (superClassIsBean) {
                    superClassName = superclass.getPackageName() + "." + (String)this.beanDefaultsNameTranslation.get((Object)superclass);
                    break;
                }
                superClassName = superclass.getQualifiedName();
            }
        }
        if (!superClassIsBean) {
            superClassName = this.getJavaTemplatesTagValues().getSimpleBeanWithNoInterfaceDefaultsSuperClassTagValue((ObjectModelClassifier)aClass, aPackage, (ObjectModel)this.model);
        }
        return superClassName;
    }

    @Override
    protected String getAttributeType(ObjectModelAttribute attr) {
        ObjectModelClass attributeClass;
        String attributeType;
        boolean hasClass;
        String attrType = super.getAttributeType(attr);
        if (!JavaGeneratorUtil.isPrimitiveType((String)attrType) && (hasClass = ((ObjectModel)this.model).hasClass(attrType)) && (attributeType = (String)this.beanNameTranslation.get((Object)(attributeClass = ((ObjectModel)this.model).getClass(attrType)))) != null) {
            attrType = attributeClass.getPackageName() + "." + attributeType;
        }
        return attrType;
    }

    @Override
    protected String getAttributeType(String attrType) {
        ObjectModelClass attributeClass;
        String attributeType;
        boolean hasClass;
        if (!JavaGeneratorUtil.isPrimitiveType((String)attrType) && (hasClass = ((ObjectModel)this.model).hasClass(attrType)) && (attributeType = (String)this.beanNameTranslation.get((Object)(attributeClass = ((ObjectModel)this.model).getClass(attrType)))) != null) {
            attrType = attributeClass.getPackageName() + "." + attributeType;
        }
        return attrType;
    }
}

