/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.kth.dks.dks_node.Interval;
import org.kth.dks.dks_node.IntervalOptimizer;
import org.kth.dks.util.MathMisc;

public class MathMiscConstant {
    public final long N;
    public final long k;
    public final IntervalOptimizer intOpt;

    public MathMiscConstant(long n, long k) {
        this.N = n;
        this.k = k;
        this.intOpt = new IntervalOptimizer(this);
    }

    public boolean belongsTo(long id, long start, long end) {
        return MathMisc.belongsTo(id, start, end, this.N);
    }

    public boolean belongsTonn(long id, long start, long end) {
        return MathMisc.belongsTonn(id, start, end, this.N);
    }

    public boolean belongsToI(long id, long start, long end) {
        return MathMisc.belongsToI(id, start, end, this.N);
    }

    public boolean belongsToII(long id, long start, long end) {
        return MathMisc.belongsToII(id, start, end, this.N);
    }

    public long distanceClockWise(long from, long to) {
        return MathMisc.distanceClockWise(from, to, this.N);
    }

    public long distanceAntiClockWise(long from, long to) {
        return MathMisc.distanceAntiClockWise(from, to, this.N);
    }

    public long modPlus(long x, long y) {
        return MathMisc.modPlus(x, y, this.N);
    }

    public long modMinus(long x, long y) {
        return MathMisc.modMinus(x, y, this.N);
    }

    public long nThroughKPowerL(int l) {
        return MathMisc.nThroughKPowerL(this.N, (int)this.k, l);
    }

    public List intervalJoin(Interval i1, Interval i2) {
        LinkedList<Interval> li = new LinkedList<Interval>();
        li.add(i1);
        li.add(i2);
        return this.intOpt.collapseIntervals(li);
    }

    public List intervalDifference(Interval i1, Interval i2) {
        LinkedList<Interval> li = new LinkedList<Interval>();
        li.add(i1);
        return this.intOpt.removeInterval(li, i2);
    }

    public Interval intervalIntersection(Interval i1, Interval i2) {
        List<Interval> li = new LinkedList<Interval>();
        li.add(i1);
        List tmp = this.intOpt.removeInterval(li, i2);
        Iterator it = tmp.iterator();
        while (it.hasNext()) {
            li = this.intOpt.removeInterval(li, (Interval)it.next());
        }
        if (li.isEmpty()) {
            return null;
        }
        return (Interval)li.get(0);
    }
}

