/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.util;

import java.util.Date;
import org.kth.dks.util.CancellationException;
import org.kth.dks.util.TimeoutException;

public class Future {
    boolean completed;
    boolean cancelled;
    Exception exception = null;
    Object value;

    public Future() {
    }

    public Future(Object value) {
        this.value = value;
        this.completed = true;
    }

    public synchronized Object get() throws InterruptedException, CancellationException, Exception {
        while (!this.completed && !this.cancelled) {
            this.wait();
        }
        if (this.completed) {
            return this.value;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        throw new CancellationException();
    }

    long now() {
        return new Date().getTime();
    }

    public synchronized Object get(long timeout) throws TimeoutException, InterruptedException, CancellationException {
        long waitUntil = this.now() + timeout;
        long waitTime = timeout;
        while (!this.completed && !this.cancelled) {
            this.wait(waitTime);
            if (this.completed || this.cancelled || (waitTime = waitUntil - this.now()) > 0L) continue;
            throw new TimeoutException();
        }
        if (this.completed) {
            return this.value;
        }
        throw new CancellationException();
    }

    public synchronized boolean isDone() {
        return this.completed;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized void store(Object value) {
        if (!this.completed && !this.cancelled) {
            this.value = value;
            this.completed = true;
            this.notifyAll();
        }
    }

    public synchronized void cancel(boolean mayInterruptIfRunning) {
        if (!this.completed) {
            this.cancelled = true;
        }
        this.notifyAll();
    }

    public synchronized void cancel(Exception ex) {
        this.exception = ex;
        if (!this.completed) {
            this.cancelled = true;
        }
        this.notifyAll();
    }
}

