/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.kth.dks.util.DKSPrintTypes;

public class DKSPrint {
    private static int logLevel = 1;
    private static Map a_enabledEntries = new HashMap();
    private static LinkedList debugInfo = new LinkedList();

    private static void addDebugInfo(String data) {
    }

    public static void logLevel(int level) {
        logLevel = level;
    }

    public static void enableType(DKSPrintTypes type) {
        a_enabledEntries.put(type, type);
    }

    public static void disableType(DKSPrintTypes type) {
        a_enabledEntries.remove(type);
    }

    public static void print(DKSPrintTypes type, String data) {
        if (DKSPrint.displayString(type)) {
            System.out.print(data);
            DKSPrint.addDebugInfo(data);
        }
    }

    public static void println(DKSPrintTypes type, String data) {
        if (DKSPrint.displayString(type)) {
            System.out.println(type + ":" + data);
            DKSPrint.addDebugInfo(type + ":" + data + "\n");
        }
    }

    public static void println_noType(DKSPrintTypes type, String data) {
        if (DKSPrint.displayString(type)) {
            System.out.println(data);
            DKSPrint.addDebugInfo(data + "\n");
        }
    }

    public static void print(DKSPrintTypes type, char data) {
        if (DKSPrint.displayString(type)) {
            System.out.print(data);
            DKSPrint.addDebugInfo("" + data);
        }
    }

    public static void print(DKSPrintTypes type, byte data) {
        if (DKSPrint.displayString(type) || logLevel == 1) {
            System.out.print(data);
            DKSPrint.addDebugInfo("" + data);
        }
    }

    public static void printXML(byte[] arr, boolean sending) {
        if (logLevel > 2) {
            System.out.print(" ###### XML MSG BEG ###### ");
            DKSPrint.addDebugInfo(" ###### XML MSG BEG ###### ");
            System.out.println(sending ? "SEND" : "RECV");
            DKSPrint.addDebugInfo((sending ? "SEND" : "RECV") + "\n");
            for (int x = 0; x < arr.length; ++x) {
                System.out.print((char)arr[x]);
                DKSPrint.addDebugInfo("" + (char)arr[x]);
            }
            System.out.println(" ###### XML MSG END ########## ");
            DKSPrint.addDebugInfo(" ###### XML MSG END ########## \n");
        }
    }

    public static String prettyPrint(String str) {
        int MAXLEN = 75;
        return str.length() < 75 ? str : str.substring(0, 75) + "..." + str.substring(str.length() - 3);
    }

    private static boolean displayString(DKSPrintTypes type) {
        switch (logLevel) {
            case 0: {
                return false;
            }
            case 1: {
                return a_enabledEntries.get(type) != null;
            }
        }
        return true;
    }

    public static Serializable getDebugInfo() {
        DebugInfo newDebugInfo = new DebugInfo(debugInfo);
        debugInfo.clear();
        return newDebugInfo;
    }

    static {
        DKSPrint.enableType(DKSPrintTypes.ERROR);
        DKSPrint.enableType(DKSPrintTypes.DKSNODE);
        DKSPrint.enableType(DKSPrintTypes.TEST);
        DKSPrint.enableType(DKSPrintTypes.TEST_BED);
    }

    static class DebugInfo
    implements Serializable {
        private String data = "";

        public DebugInfo(LinkedList debugInfo) {
            for (int i = 0; i < debugInfo.size(); ++i) {
                this.data = this.data + debugInfo.get(i);
            }
        }

        public String toString() {
            return this.data;
        }
    }
}

